/*
 * Decompiled with CFR 0.152.
 */
package com.naskar.fluentquery.converters;

import com.naskar.fluentquery.Into;
import com.naskar.fluentquery.Value;
import com.naskar.fluentquery.conventions.SimpleConvention;
import com.naskar.fluentquery.converters.NativeSQL;
import com.naskar.fluentquery.converters.NativeSQLResult;
import com.naskar.fluentquery.converters.NativeSQLWhereImpl;
import com.naskar.fluentquery.impl.Convention;
import com.naskar.fluentquery.impl.HolderInt;
import com.naskar.fluentquery.impl.MethodRecordProxy;
import com.naskar.fluentquery.impl.Tuple;
import com.naskar.fluentquery.impl.TypeUtils;
import com.naskar.fluentquery.impl.UpdateConverter;
import com.naskar.fluentquery.impl.UpdateImpl;
import com.naskar.fluentquery.impl.UpdateParts;
import com.naskar.fluentquery.impl.ValueImpl;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class NativeSQLUpdate
implements UpdateConverter<NativeSQLResult> {
    private Convention convention;
    private NativeSQL nativeSQL;
    private NativeSQLWhereImpl nativeWhereImpl;
    private boolean withoutAlias;
    private boolean withoutTableName;

    public NativeSQLUpdate(Convention convention) {
        this.convention = convention;
        this.nativeSQL = new NativeSQL();
        this.nativeSQL.setConvention(convention);
        this.nativeWhereImpl = new NativeSQLWhereImpl(this.nativeSQL);
        this.nativeWhereImpl.setConvention(convention);
        this.withoutAlias = true;
        this.withoutTableName = false;
    }

    public NativeSQLUpdate setWithoutAlias(boolean withoutAlias) {
        this.withoutAlias = withoutAlias;
        return this;
    }

    public NativeSQLUpdate setWithoutTableName(boolean withoutTableName) {
        this.withoutTableName = withoutTableName;
        return this;
    }

    public NativeSQLUpdate() {
        this(new SimpleConvention());
    }

    public NativeSQLUpdate setConvention(Convention convention) {
        this.convention = convention;
        this.nativeSQL.setConvention(convention);
        this.nativeWhereImpl.setConvention(convention);
        return this;
    }

    @Override
    public <T> NativeSQLResult convert(UpdateImpl<T> updateImpl) {
        NativeSQLResult result = new NativeSQLResult();
        UpdateParts parts = new UpdateParts();
        HolderInt level = new HolderInt();
        level.value = 0;
        this.convert(updateImpl, parts, level, result, null);
        StringBuilder sb = new StringBuilder();
        sb.append("update ");
        if (!this.withoutTableName) {
            sb.append((CharSequence)parts.getTable());
        }
        sb.append(" set ");
        sb.append((CharSequence)parts.getSet());
        if (parts.hasWhere()) {
            sb.append(" where ");
            sb.append((CharSequence)parts.getWhere());
        }
        return result.sql(sb.toString());
    }

    private <T> void convert(UpdateImpl<T> updateImpl, UpdateParts parts, HolderInt level, NativeSQLResult result, List<String> parents) {
        MethodRecordProxy<T> proxy = TypeUtils.createProxy(updateImpl.getClazz());
        String alias = this.withoutAlias ? "" : "e" + level + ".";
        this.convertTable(parts.getTable(), alias, updateImpl.getClazz());
        this.convertSet(parts.getSet(), alias, proxy, updateImpl.getValues(), result);
        this.nativeWhereImpl.convertWhere(parts.getWhere(), level, alias, proxy, parents, updateImpl.getPredicates(), result);
    }

    private <T> void convertTable(StringBuilder sb, String alias, Class<T> clazz) {
        String sufix = this.withoutAlias ? "" : " " + alias.substring(0, alias.length() - 1);
        sb.append(this.convention.getNameFromClass(clazz) + sufix);
    }

    private <T> void convertSet(StringBuilder sb, String alias, MethodRecordProxy<T> proxy, List<Tuple<Function<T, ?>, Value<Into<T>, ?>>> values, NativeSQLResult result) {
        String s = values.stream().map(i -> {
            ValueImpl valueImpl = (ValueImpl)i.getT2();
            Object value = valueImpl.get();
            proxy.clear();
            ((Function)i.getT1()).apply(proxy.getProxy());
            String name = alias + this.convention.getNameFromMethod(proxy.getMethods());
            return name + " = :" + result.add(value);
        }).collect(Collectors.joining(", "));
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(s);
    }
}

