/*
 * Decompiled with CFR 0.152.
 */
package com.naskar.fluentquery.jpa.dao.impl;

import com.naskar.fluentquery.Delete;
import com.naskar.fluentquery.DeleteBuilder;
import com.naskar.fluentquery.InsertBuilder;
import com.naskar.fluentquery.Into;
import com.naskar.fluentquery.Query;
import com.naskar.fluentquery.QueryBuilder;
import com.naskar.fluentquery.Update;
import com.naskar.fluentquery.UpdateBuilder;
import com.naskar.fluentquery.binder.BinderSQL;
import com.naskar.fluentquery.binder.BinderSQLBuilder;
import com.naskar.fluentquery.converters.NativeSQL;
import com.naskar.fluentquery.converters.NativeSQLDelete;
import com.naskar.fluentquery.converters.NativeSQLInsertInto;
import com.naskar.fluentquery.converters.NativeSQLResult;
import com.naskar.fluentquery.converters.NativeSQLUpdate;
import com.naskar.fluentquery.impl.Convention;
import com.naskar.fluentquery.impl.DeleteConverter;
import com.naskar.fluentquery.impl.IntoConverter;
import com.naskar.fluentquery.impl.QueryConverter;
import com.naskar.fluentquery.impl.UpdateConverter;
import com.naskar.fluentquery.jpa.dao.DAO;
import com.naskar.fluentquery.jpa.dao.RowHandler;
import com.naskar.fluentquery.jpa.dao.impl.SubListImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;

public class DAOImpl
implements DAO {
    private EntityManager em;
    private NativeSQL nativeSQL = new NativeSQL();
    private QueryBuilder queryBuilder = new QueryBuilder();
    private NativeSQLInsertInto insertSQL = new NativeSQLInsertInto();
    private InsertBuilder insertBuilder = new InsertBuilder();
    private NativeSQLUpdate updateSQL = new NativeSQLUpdate();
    private UpdateBuilder updateBuilder = new UpdateBuilder();
    private NativeSQLDelete deleteSQL = new NativeSQLDelete();
    private DeleteBuilder deleteBuilder = new DeleteBuilder();
    private BinderSQLBuilder binderBuilder = new BinderSQLBuilder();
    private static final List<Integer> BINARY_TYPES = Arrays.asList(-2, -4, -3);

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected EntityManager getEm() {
        return this.em;
    }

    public void setConvention(Convention convention) {
        this.nativeSQL.setConvention(convention);
        this.insertSQL.setConvention(convention);
        this.updateSQL.setConvention(convention);
        this.deleteSQL.setConvention(convention);
    }

    @Override
    public <T> T insert(T o) {
        this.em.persist(o);
        this.em.flush();
        return o;
    }

    @Override
    public <T> T update(T o) {
        Object no = this.em.merge(o);
        this.em.flush();
        return (T)no;
    }

    @Override
    public <T> T delete(T o) {
        this.em.remove(this.em.merge(o));
        this.em.flush();
        return o;
    }

    @Override
    public <T> Into<T> insert(Class<T> clazz) {
        return this.insertBuilder.into(clazz);
    }

    @Override
    public <T> Update<T> update(Class<T> clazz) {
        return this.updateBuilder.entity(clazz);
    }

    @Override
    public <T> Delete<T> delete(Class<T> clazz) {
        return this.deleteBuilder.entity(clazz);
    }

    @Override
    public <T> void execute(Into<T> into) {
        NativeSQLResult result = (NativeSQLResult)into.to((IntoConverter)this.insertSQL);
        this.nativeExecute(result.sqlValues(), result.values(), null);
    }

    @Override
    public <T> void execute(Update<T> update) {
        NativeSQLResult result = (NativeSQLResult)update.to((UpdateConverter)this.updateSQL);
        this.nativeExecute(result.sqlValues(), result.values(), null);
    }

    @Override
    public <T> void execute(Delete<T> delete) {
        NativeSQLResult result = (NativeSQLResult)delete.to((DeleteConverter)this.deleteSQL);
        this.nativeExecute(result.sqlValues(), result.values(), null);
    }

    @Override
    public <R> void execute(BinderSQL<R> binder, R r) {
        NativeSQLResult result = binder.bind(r);
        this.nativeExecute(result.sqlValues(), result.values(), null);
    }

    @Override
    public <R> BinderSQL<R> binder(Class<R> clazz) {
        return this.binderBuilder.from(clazz);
    }

    @Override
    public <R, T> void configure(BinderSQL<R> binder, Into<T> into) {
        binder.configure((NativeSQLResult)into.to((IntoConverter)this.insertSQL));
    }

    @Override
    public <T> javax.persistence.Query nativeQuery(Query<T> query) {
        NativeSQLResult result = (NativeSQLResult)query.to((QueryConverter)this.nativeSQL);
        javax.persistence.Query q = this.em.createNativeQuery(result.sqlValues());
        this.addParams(q, (List<Object>)result.values());
        return q;
    }

    @Override
    public List<Map<String, Object>> list(String sql, List<Object> params, Long first, Long max) {
        javax.persistence.Query q = this.em.createNativeQuery(sql);
        q.setHint("eclipselink.result-type", (Object)"Map");
        this.addParams(q, params);
        Long count = -1L;
        if (first != null) {
            q.setFirstResult(first.intValue());
            count = this.getCount(sql, params);
        }
        if (max != null) {
            q.setMaxResults(max.intValue());
        }
        List dbResult = q.getResultList();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(dbResult.size());
        dbResult.forEach(i -> {
            HashMap m = new HashMap();
            i.forEach((k, v) -> m.put(k.toString().toLowerCase(), v));
            result.add(m);
        });
        if (first != null) {
            return new SubListImpl<Map<String, Object>>(result, first, max, count);
        }
        return result;
    }

    private <T> List<T> list(Class<T> clazz, String sql, List<Object> params, Long first, Long max) {
        javax.persistence.Query q = this.em.createNativeQuery(sql, clazz);
        this.addParams(q, params);
        Long count = -1L;
        if (first != null) {
            q.setFirstResult(first.intValue());
            count = this.getCount(sql, params);
        }
        if (max != null) {
            q.setMaxResults(max.intValue());
        }
        SubListImpl result = q.getResultList();
        if (first != null) {
            result = new SubListImpl(result, first, max, count);
        }
        return result;
    }

    private void addParams(PreparedStatement st, List<Object> params) throws SQLException {
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                Object o = params.get(i);
                if (o instanceof Date) {
                    st.setTimestamp(i + 1, new Timestamp(((Date)o).getTime()));
                    continue;
                }
                if (o instanceof File) {
                    try {
                        st.setBinaryStream(i + 1, new FileInputStream((File)o));
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (o instanceof InputStream) {
                    try {
                        st.setBinaryStream(i + 1, (InputStream)o);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                st.setObject(i + 1, o);
            }
        }
    }

    private void addParams(javax.persistence.Query q, List<Object> params) {
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                q.setParameter(i + 1, params.get(i));
            }
        }
    }

    private Long getCount(String sql, List<Object> params) {
        String sqlCount = sql;
        javax.persistence.Query q = this.em.createNativeQuery("SELECT COUNT(*) FROM (" + sqlCount + ") _v");
        this.addParams(q, params);
        return ((Number)q.getSingleResult()).longValue();
    }

    @Override
    public <T> List<T> list(Query<T> query) {
        return this.list(query, null, null);
    }

    @Override
    public <T> List<T> list(Query<T> query, Long first, Long max) {
        NativeSQLResult result = (NativeSQLResult)query.to((QueryConverter)this.nativeSQL);
        return this.list(query.getClazz(), result.sqlValues(), result.values(), first, max);
    }

    private Map<String, Field> getFields(Class<?> clazz) {
        HashMap<String, Field> m = new HashMap<String, Field>();
        for (Field f : clazz.getDeclaredFields()) {
            m.put(f.getName().toLowerCase(), f);
        }
        return m;
    }

    @Override
    public <T, R> List<R> list(Query<T> query, Class<R> clazzR) {
        Map<String, Field> m = this.getFields(clazzR);
        ArrayList l = new ArrayList();
        NativeSQLResult result = (NativeSQLResult)query.to((QueryConverter)this.nativeSQL);
        this.nativeSQL(result.sqlValues(), result.values(), row -> {
            try {
                Object r = clazzR.newInstance();
                for (Map.Entry e : row.entrySet()) {
                    Field f = (Field)m.get(((String)e.getKey()).toLowerCase());
                    if (f == null) continue;
                    f.setAccessible(true);
                    f.set(r, e.getValue());
                }
                l.add(r);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return true;
        });
        return l;
    }

    @Override
    public <T> Query<T> query(Class<T> clazz) {
        return this.queryBuilder.from(clazz);
    }

    private <T> T single(Class<T> clazz, String sql, List<Object> params) {
        try {
            javax.persistence.Query q = this.em.createNativeQuery(sql, clazz);
            q.setMaxResults(1);
            this.addParams(q, params);
            return (T)q.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    @Override
    public void nativeSQL(String sql, List<Object> params, RowHandler handler) {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = ((Connection)this.em.unwrap(Connection.class)).prepareStatement(sql);
            this.addParams(st, params);
            rs = st.executeQuery();
            this.forEachHandler(rs, handler);
        }
        catch (Exception e) {
            System.out.println("SQL:" + sql + "\nParams:" + params);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void forEachHandler(ResultSet rs, RowHandler handler) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        while (rs.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int j = 1; j <= md.getColumnCount(); ++j) {
                if (BINARY_TYPES.contains(md.getColumnType(j))) {
                    row.put(md.getColumnName(j), rs.getBinaryStream(j));
                    continue;
                }
                row.put(md.getColumnName(j), rs.getObject(j));
            }
            if (handler.execute(row)) continue;
            break;
        }
    }

    @Override
    public <T> T single(Query<T> query) {
        NativeSQLResult result = (NativeSQLResult)query.to((QueryConverter)this.nativeSQL);
        return this.single(query.getClazz(), result.sqlValues(), result.values());
    }

    @Override
    public void insert(String table, Map<String, Object> params, BiConsumer<String, List<Object>> call) {
        ArrayList columns = new ArrayList();
        ArrayList values = new ArrayList();
        ArrayList p = new ArrayList();
        params.forEach((k, v) -> {
            columns.add(k);
            values.add(v);
            p.add("?");
        });
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ");
        sb.append(table);
        sb.append(columns.stream().map(i -> i.toString()).collect(Collectors.joining(", ", " (", ")")));
        sb.append(p.stream().map(i -> i.toString()).collect(Collectors.joining(", ", " values (", ")")));
        call.accept(sb.toString(), values);
    }

    @Override
    public void update(String table, Map<String, Object> params, Map<String, Object> where, BiConsumer<String, List<Object>> call) {
        ArrayList columns = new ArrayList();
        ArrayList columnsWhere = new ArrayList();
        ArrayList values = new ArrayList();
        params.forEach((k, v) -> {
            columns.add(k + " = ? ");
            values.add(v);
        });
        where.forEach((k, v) -> {
            columnsWhere.add(k + " = ? ");
            values.add(v);
        });
        StringBuilder sb = new StringBuilder();
        sb.append("update ");
        sb.append(table);
        sb.append(columns.stream().map(i -> i.toString()).collect(Collectors.joining(", ", " set ", " ")));
        sb.append(columnsWhere.stream().map(i -> i.toString()).collect(Collectors.joining(" and ", "where ", "")));
        call.accept(sb.toString(), values);
    }

    @Override
    public void delete(String table, Map<String, Object> where, BiConsumer<String, List<Object>> call) {
        ArrayList columnsWhere = new ArrayList();
        ArrayList values = new ArrayList();
        where.forEach((k, v) -> {
            columnsWhere.add(k + " = ? ");
            values.add(v);
        });
        StringBuilder sb = new StringBuilder();
        sb.append("delete from ");
        sb.append(table);
        sb.append(columnsWhere.stream().map(i -> i.toString()).collect(Collectors.joining(" and ", " where ", " ")));
        call.accept(sb.toString(), values);
    }

    @Override
    public void nativeExecute(String sql, List<Object> params, RowHandler handlerKeys) {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = ((Connection)this.em.unwrap(Connection.class)).prepareStatement(sql, 1);
            this.addParams(st, params);
            st.executeUpdate();
            if (handlerKeys != null && (rs = st.getGeneratedKeys()) != null) {
                this.forEachHandler(rs, handlerKeys);
            }
        }
        catch (Exception e) {
            System.out.println("SQL:" + sql + " params: " + params);
            throw new RuntimeException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public List<String> getColumnsFromTable(String tableName) {
        ArrayList<String> names = new ArrayList<String>();
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = (Connection)this.em.unwrap(Connection.class);
            DatabaseMetaData meta = conn.getMetaData();
            String[] tableAttrs = this.getTableAttrs(tableName.toLowerCase());
            rs = meta.getColumns(null, tableAttrs[0], tableAttrs[1], null);
            while (rs.next()) {
                names.add(rs.getString("COLUMN_NAME").toLowerCase());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return names;
    }

    @Override
    public List<String> getPrimaryKeyFromTable(String tableName) {
        ArrayList<String> names = new ArrayList<String>();
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = (Connection)this.em.unwrap(Connection.class);
            DatabaseMetaData meta = conn.getMetaData();
            String[] tableAttrs = this.getTableAttrs(tableName.toLowerCase());
            rs = meta.getPrimaryKeys(null, tableAttrs[0], tableAttrs[1]);
            while (rs.next()) {
                names.add(rs.getString("COLUMN_NAME").toLowerCase());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return names;
    }

    private String[] getTableAttrs(String tableName) {
        String[] parts;
        String catalog = null;
        String table = tableName;
        if (tableName.contains(".") && (parts = tableName.split(Pattern.quote("."))).length == 2) {
            catalog = parts[0];
            table = parts[1];
        }
        return new String[]{catalog, table};
    }
}

