/*
 * Decompiled with CFR 0.152.
 */
package com.naskar.fluentquery.jpa;

import com.naskar.fluentquery.jpa.SharedEntityManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import javax.persistence.EntityManager;

public class EntityManagerInvocationHandler
implements InvocationHandler {
    private Object target;
    private SharedEntityManager sem;
    private Supplier<EntityManager> entityManagerSupplier;

    public EntityManagerInvocationHandler(Object target, SharedEntityManager sem, Supplier<EntityManager> entityManagerSupplier) {
        this.target = target;
        this.sem = sem;
        this.entityManagerSupplier = entityManagerSupplier;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        EntityManager em = null;
        boolean created = false;
        try {
            em = this.sem.getEntityManager();
            if (em == null) {
                em = this.entityManagerSupplier.get();
                em.getTransaction().begin();
                this.sem.set(em);
                created = true;
            }
            result = method.invoke(this.target, args);
            if (created) {
                em.getTransaction().commit();
            }
        }
        catch (Exception e) {
            if (created && em != null) {
                try {
                    em.getTransaction().rollback();
                }
                catch (Exception et) {
                    et.printStackTrace();
                }
            }
            if (e instanceof InvocationTargetException) {
                throw ((InvocationTargetException)e).getTargetException();
            }
            throw e;
        }
        finally {
            if (created) {
                this.sem.removeEntityManager();
                if (em != null) {
                    em.close();
                }
            }
        }
        return result;
    }

    public Object getTarget() {
        return this.target;
    }
}

