/*
 * Decompiled with CFR 0.152.
 */
package com.naskar.fluentquery.eclipselink.conventions;

import com.naskar.fluentquery.impl.Convention;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.sessions.Session;

public class EclipseLinkConvention
implements Convention {
    private Map<String, String> clazzes = new HashMap<String, String>();
    private Map<String, Map<String, String>> methods = new HashMap<String, Map<String, String>>();

    @Deprecated
    public void addAll(EntityManagerFactory factory) {
        try (EntityManager em = null;){
            em = factory.createEntityManager();
            this.addAll(this.getSession(em));
        }
    }

    public void addAll(EntityManager em) {
        this.addAll(this.getSession(em));
    }

    private Session getSession(EntityManager em) {
        Session session = (Session)em.unwrap(Session.class);
        if (session == null) {
            throw new RuntimeException("No eclipselink session found.");
        }
        return session;
    }

    public void addAll(Session session) {
        boolean toUpperCase = System.getProperty("com.naskar.fluentquery.eclipselink.uppercase", "false").equalsIgnoreCase("true");
        Map descriptors = session.getDescriptors();
        for (Map.Entry e : descriptors.entrySet()) {
            Class clazz = (Class)e.getKey();
            ClassDescriptor cd = (ClassDescriptor)e.getValue();
            String tableName = (String)cd.getTableNames().get(0);
            if (toUpperCase) {
                tableName = tableName.toUpperCase();
            }
            this.clazzes.put(clazz.getName(), tableName);
            HashMap<String, String> fields = new HashMap<String, String>();
            this.methods.put(clazz.getName(), fields);
            for (DatabaseMapping dm : cd.getMappings()) {
                String attributeName = dm.getAttributeName();
                String method = "get" + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1);
                DatabaseField field = dm.getField();
                if (field != null) {
                    String columnName = field.getName();
                    if (toUpperCase) {
                        columnName = columnName.toUpperCase();
                    }
                    fields.put(method, columnName);
                    continue;
                }
                if (dm.getFields() == null) continue;
                Vector fieldsMappings = dm.getFields();
                if (fieldsMappings.size() > 1) {
                    throw new UnsupportedOperationException();
                }
                if (fieldsMappings.isEmpty()) continue;
                String columnName = ((DatabaseField)fieldsMappings.get(0)).getName();
                if (toUpperCase) {
                    columnName = columnName.toUpperCase();
                }
                fields.put(method, columnName);
            }
        }
    }

    public <T> String getNameFromClass(Class<T> clazz) {
        return this.clazzes.get(clazz.getName());
    }

    public String getNameFromMethod(List<Method> methods) {
        if (methods.size() > 1) {
            throw new UnsupportedOperationException(methods.toString());
        }
        String name = null;
        if (!methods.isEmpty()) {
            name = this.getNameFromMethod(methods.get(0));
        }
        return name;
    }

    public String getNameFromMethod(Method m) {
        String name = null;
        Map<String, String> fields = this.methods.get(m.getDeclaringClass().getName());
        if (fields != null) {
            name = fields.get(m.getName());
        }
        return name;
    }
}

