/*
 * Decompiled with CFR 0.152.
 */
package com.nanchen.compresshelper;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.nanchen.compresshelper.BitmapUtil;
import java.io.File;

public class CompressHelper {
    private static volatile CompressHelper INSTANCE;
    private Context context;
    private float maxWidth = 720.0f;
    private float maxHeight = 960.0f;
    private Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
    private Bitmap.Config bitmapConfig = Bitmap.Config.ARGB_8888;
    private int quality = 80;
    private String destinationDirectoryPath;
    private String fileNamePrefix;
    private String fileName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CompressHelper getDefault(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<CompressHelper> clazz = CompressHelper.class;
        synchronized (CompressHelper.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new CompressHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private CompressHelper(Context context) {
        this.context = context;
        this.destinationDirectoryPath = context.getCacheDir().getPath() + File.pathSeparator + "CompressHelper";
    }

    public File compressToFile(File file) {
        return BitmapUtil.compressImage(this.context, Uri.fromFile((File)file), this.maxWidth, this.maxHeight, this.compressFormat, this.bitmapConfig, this.quality, this.destinationDirectoryPath, this.fileNamePrefix, this.fileName);
    }

    public Bitmap compressToBitmap(File file) {
        return BitmapUtil.getScaledBitmap(this.context, Uri.fromFile((File)file), this.maxWidth, this.maxHeight, this.bitmapConfig);
    }

    public static class Builder {
        private CompressHelper mCompressHelper;

        public Builder(Context context) {
            this.mCompressHelper = new CompressHelper(context);
        }

        public Builder setMaxWidth(float maxWidth) {
            this.mCompressHelper.maxWidth = maxWidth;
            return this;
        }

        public Builder setMaxHeight(float maxHeight) {
            this.mCompressHelper.maxHeight = maxHeight;
            return this;
        }

        public Builder setCompressFormat(Bitmap.CompressFormat compressFormat) {
            this.mCompressHelper.compressFormat = compressFormat;
            return this;
        }

        public Builder setBitmapConfig(Bitmap.Config bitmapConfig) {
            this.mCompressHelper.bitmapConfig = bitmapConfig;
            return this;
        }

        public Builder setQuality(int quality) {
            this.mCompressHelper.quality = quality;
            return this;
        }

        public Builder setDestinationDirectoryPath(String destinationDirectoryPath) {
            this.mCompressHelper.destinationDirectoryPath = destinationDirectoryPath;
            return this;
        }

        public Builder setFileNamePrefix(String prefix) {
            this.mCompressHelper.fileNamePrefix = prefix;
            return this;
        }

        public Builder setFileName(String fileName) {
            this.mCompressHelper.fileName = fileName;
            return this;
        }

        public CompressHelper build() {
            return this.mCompressHelper;
        }
    }
}

