/*
 * Decompiled with CFR 0.152.
 */
package com.nanchen.bankcardutil;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import android.widget.Toast;
import com.nanchen.bankcardutil.R;

public class ContentWithSpaceEditText
extends AppCompatEditText {
    public static final int TYPE_PHONE = 0;
    public static final int TYPE_BANK_CARD = 1;
    public static final int TYPE_ID_CARD = 2;
    private int start;
    private int count;
    private int before;
    private int contentType;
    private int maxLength = 50;
    private String digits;
    private TextWatcher watcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            ContentWithSpaceEditText.this.start = start;
            ContentWithSpaceEditText.this.before = before;
            ContentWithSpaceEditText.this.count = count;
        }

        public void afterTextChanged(Editable s) {
            if (s == null) {
                return;
            }
            boolean isMiddle = ContentWithSpaceEditText.this.start + ContentWithSpaceEditText.this.count < s.length();
            boolean isNeedSpace = false;
            if (!isMiddle && ContentWithSpaceEditText.this.isSpace(s.length())) {
                isNeedSpace = true;
            }
            if (isMiddle || isNeedSpace || ContentWithSpaceEditText.this.count > 1) {
                String newStr = s.toString();
                newStr = newStr.replace(" ", "");
                StringBuilder sb = new StringBuilder();
                int spaceCount = 0;
                for (int i = 0; i < newStr.length(); ++i) {
                    sb.append(newStr.substring(i, i + 1));
                    if (!ContentWithSpaceEditText.this.isSpace(i + 2 + spaceCount)) continue;
                    sb.append(" ");
                    ++spaceCount;
                }
                ContentWithSpaceEditText.this.removeTextChangedListener(ContentWithSpaceEditText.this.watcher);
                s.replace(0, s.length(), (CharSequence)sb);
                if (!isMiddle || ContentWithSpaceEditText.this.count > 1) {
                    ContentWithSpaceEditText.this.setSelection(s.length() <= ContentWithSpaceEditText.this.maxLength ? s.length() : ContentWithSpaceEditText.this.maxLength);
                } else if (ContentWithSpaceEditText.this.count == 0) {
                    if (ContentWithSpaceEditText.this.isSpace(ContentWithSpaceEditText.this.start - ContentWithSpaceEditText.this.before + 1)) {
                        ContentWithSpaceEditText.this.setSelection(ContentWithSpaceEditText.this.start - ContentWithSpaceEditText.this.before > 0 ? ContentWithSpaceEditText.this.start - ContentWithSpaceEditText.this.before : 0);
                    } else {
                        ContentWithSpaceEditText.this.setSelection(ContentWithSpaceEditText.this.start - ContentWithSpaceEditText.this.before + 1 > s.length() ? s.length() : ContentWithSpaceEditText.this.start - ContentWithSpaceEditText.this.before + 1);
                    }
                } else if (ContentWithSpaceEditText.this.isSpace(ContentWithSpaceEditText.this.start - ContentWithSpaceEditText.this.before + ContentWithSpaceEditText.this.count)) {
                    ContentWithSpaceEditText.this.setSelection(ContentWithSpaceEditText.this.start + ContentWithSpaceEditText.this.count - ContentWithSpaceEditText.this.before + 1 < s.length() ? ContentWithSpaceEditText.this.start + ContentWithSpaceEditText.this.count - ContentWithSpaceEditText.this.before + 1 : s.length());
                } else {
                    ContentWithSpaceEditText.this.setSelection(ContentWithSpaceEditText.this.start + ContentWithSpaceEditText.this.count - ContentWithSpaceEditText.this.before);
                }
                ContentWithSpaceEditText.this.addTextChangedListener(ContentWithSpaceEditText.this.watcher);
            }
        }
    };

    public ContentWithSpaceEditText(Context context) {
        this(context, null);
    }

    public ContentWithSpaceEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.parseAttributeSet(context, attrs);
    }

    public ContentWithSpaceEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.parseAttributeSet(context, attrs);
    }

    private void parseAttributeSet(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ContentWithSpaceEditText, 0, 0);
        this.contentType = ta.getInt(R.styleable.ContentWithSpaceEditText_input_type, 0);
        ta.recycle();
        this.initType();
        this.setSingleLine();
        this.addTextChangedListener(this.watcher);
    }

    private void initType() {
        if (this.contentType == 0) {
            this.maxLength = 13;
            this.digits = "0123456789 ";
            this.setInputType(2);
        } else if (this.contentType == 1) {
            this.maxLength = 31;
            this.digits = "0123456789 ";
            this.setInputType(2);
        } else if (this.contentType == 2) {
            this.maxLength = 21;
            this.digits = null;
            this.setInputType(1);
        }
        this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.maxLength)});
    }

    public void setInputType(int type) {
        if (this.contentType == 0 || this.contentType == 1) {
            type = 2;
        } else if (this.contentType == 2) {
            type = 1;
        }
        super.setInputType(type);
        if (!TextUtils.isEmpty((CharSequence)this.digits)) {
            this.setKeyListener((KeyListener)DigitsKeyListener.getInstance((String)this.digits));
        }
    }

    public void setContentType(int contentType) {
        this.contentType = contentType;
        this.initType();
    }

    public String getTextWithoutSpace() {
        return super.getText().toString().replace(" ", "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTextRight() {
        String text = this.getTextWithoutSpace();
        if (this.contentType == 0) {
            if (TextUtils.isEmpty((CharSequence)text)) {
                this.showShort(this.getContext(), "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
                return false;
            } else {
                if (text.length() >= 11) return true;
                this.showShort(this.getContext(), "\u624b\u673a\u53f7\u4e0d\u8db311\u4f4d\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
            }
            return false;
        } else if (this.contentType == 1) {
            if (TextUtils.isEmpty((CharSequence)text)) {
                this.showShort(this.getContext(), "\u94f6\u884c\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u94f6\u884c\u5361\u53f7");
                return false;
            } else {
                if (text.length() >= 14) return true;
                this.showShort(this.getContext(), "\u94f6\u884c\u5361\u53f7\u4f4d\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u94f6\u884c\u5361\u53f7");
            }
            return false;
        } else {
            if (this.contentType != 2) return false;
            if (TextUtils.isEmpty((CharSequence)text)) {
                this.showShort(this.getContext(), "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8eab\u4efd\u8bc1\u53f7");
                return false;
            } else {
                if (text.length() >= 18) return true;
                this.showShort(this.getContext(), "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8eab\u4efd\u8bc1\u53f7");
            }
        }
        return false;
    }

    private void showShort(Context context, String msg) {
        Toast.makeText((Context)context.getApplicationContext(), (CharSequence)msg, (int)0).show();
    }

    private boolean isSpace(int length) {
        if (this.contentType == 0) {
            return this.isSpacePhone(length);
        }
        if (this.contentType == 1) {
            return this.isSpaceCard(length);
        }
        if (this.contentType == 2) {
            return this.isSpaceIDCard(length);
        }
        return false;
    }

    private boolean isSpacePhone(int length) {
        return length >= 4 && (length == 4 || (length + 1) % 5 == 0);
    }

    private boolean isSpaceCard(int length) {
        return length % 5 == 0;
    }

    private boolean isSpaceIDCard(int length) {
        return length > 6 && (length == 7 || (length - 2) % 5 == 0);
    }
}

