/*
 * Decompiled with CFR 0.152.
 */
package com.naman14.androidlame;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class WaveReader {
    private static final int WAV_HEADER_CHUNK_ID = 1380533830;
    private static final int WAV_FORMAT = 1463899717;
    private static final int WAV_FORMAT_CHUNK_ID = 1718449184;
    private static final int WAV_DATA_CHUNK_ID = 1684108385;
    private static final int STREAM_BUFFER_SIZE = 4096;
    private File mInFile;
    private BufferedInputStream mInStream;
    private int mSampleRate;
    private int mChannels;
    private int mSampleBits;
    private int mFileSize;
    private int mDataSize;

    public WaveReader(String path, String name) {
        this.mInFile = new File(path + File.separator + name);
    }

    public WaveReader(File file) {
        this.mInFile = file;
    }

    public void openWave() throws FileNotFoundException, InvalidWaveException, IOException {
        short audioFormat;
        FileInputStream fileStream = new FileInputStream(this.mInFile);
        this.mInStream = new BufferedInputStream(fileStream, 4096);
        int headerId = WaveReader.readUnsignedInt(this.mInStream);
        if (headerId != 1380533830) {
            throw new InvalidWaveException(String.format("Invalid WAVE header chunk ID: %d", headerId));
        }
        this.mFileSize = WaveReader.readUnsignedIntLE(this.mInStream);
        int format = WaveReader.readUnsignedInt(this.mInStream);
        if (format != 1463899717) {
            throw new InvalidWaveException("Invalid WAVE format");
        }
        int formatId = WaveReader.readUnsignedInt(this.mInStream);
        if (formatId != 1718449184) {
            throw new InvalidWaveException("Invalid WAVE format chunk ID");
        }
        int formatSize = WaveReader.readUnsignedIntLE(this.mInStream);
        if (formatSize != 16) {
            // empty if block
        }
        if ((audioFormat = WaveReader.readUnsignedShortLE(this.mInStream)) != 1) {
            throw new InvalidWaveException("Not PCM WAVE format");
        }
        this.mChannels = WaveReader.readUnsignedShortLE(this.mInStream);
        this.mSampleRate = WaveReader.readUnsignedIntLE(this.mInStream);
        int byteRate = WaveReader.readUnsignedIntLE(this.mInStream);
        short blockAlign = WaveReader.readUnsignedShortLE(this.mInStream);
        this.mSampleBits = WaveReader.readUnsignedShortLE(this.mInStream);
        int dataId = WaveReader.readUnsignedInt(this.mInStream);
        if (dataId != 1684108385) {
            throw new InvalidWaveException("Invalid WAVE data chunk ID");
        }
        this.mDataSize = WaveReader.readUnsignedIntLE(this.mInStream);
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getChannels() {
        return this.mChannels;
    }

    public int getPcmFormat() {
        return this.mSampleBits;
    }

    public int getFileSize() {
        return this.mFileSize + 8;
    }

    public int getDataSize() {
        return this.mDataSize;
    }

    public int getLength() {
        if (this.mSampleRate == 0 || this.mChannels == 0 || (this.mSampleBits + 7) / 8 == 0) {
            return 0;
        }
        return this.mDataSize / (this.mSampleRate * this.mChannels * ((this.mSampleBits + 7) / 8));
    }

    public int read(short[] dst, int numSamples) throws IOException {
        if (this.mChannels != 1) {
            return -1;
        }
        byte[] buf = new byte[numSamples * 2];
        int index = 0;
        int bytesRead = this.mInStream.read(buf, 0, numSamples * 2);
        for (int i = 0; i < bytesRead; i += 2) {
            dst[index] = WaveReader.byteToShortLE(buf[i], buf[i + 1]);
            ++index;
        }
        return index;
    }

    public int read(short[] left, short[] right, int numSamples) throws IOException {
        if (this.mChannels != 2) {
            return -1;
        }
        byte[] buf = new byte[numSamples * 4];
        int index = 0;
        int bytesRead = this.mInStream.read(buf, 0, numSamples * 4);
        for (int i = 0; i < bytesRead; i += 2) {
            short val = WaveReader.byteToShortLE(buf[0], buf[i + 1]);
            if (i % 4 == 0) {
                left[index] = val;
                continue;
            }
            right[index] = val;
            ++index;
        }
        return index;
    }

    public void closeWaveFile() throws IOException {
        if (this.mInStream != null) {
            this.mInStream.close();
        }
    }

    private static short byteToShortLE(byte b1, byte b2) {
        return (short)(b1 & 0xFF | (b2 & 0xFF) << 8);
    }

    private static int readUnsignedInt(BufferedInputStream in) throws IOException {
        byte[] buf = new byte[4];
        int ret = in.read(buf);
        if (ret == -1) {
            return -1;
        }
        return (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
    }

    private static int readUnsignedIntLE(BufferedInputStream in) throws IOException {
        byte[] buf = new byte[4];
        int ret = in.read(buf);
        if (ret == -1) {
            return -1;
        }
        return buf[0] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[2] & 0xFF) << 16 | (buf[3] & 0xFF) << 24;
    }

    private static short readUnsignedShortLE(BufferedInputStream in) throws IOException {
        byte[] buf = new byte[2];
        int ret = in.read(buf, 0, 2);
        if (ret == -1) {
            return -1;
        }
        return WaveReader.byteToShortLE(buf[0], buf[1]);
    }

    public class InvalidWaveException
    extends IOException {
        private static final long serialVersionUID = -8229742633848759378L;

        public InvalidWaveException() {
        }

        public InvalidWaveException(String msg) {
            super(msg);
        }
    }
}

