/*
 * Decompiled with CFR 0.152.
 */
package com.naman14.androidlame;

import com.naman14.androidlame.LameBuilder;

public class AndroidLame {
    public AndroidLame() {
        AndroidLame.initializeDefault();
    }

    public AndroidLame(LameBuilder builder) {
        this.initialize(builder);
    }

    private void initialize(LameBuilder builder) {
        AndroidLame.initialize(builder.inSampleRate, builder.outChannel, builder.outSampleRate, builder.outBitrate, builder.scaleInput, AndroidLame.getIntForMode(builder.mode), AndroidLame.getIntForVbrMode(builder.vbrMode), builder.quality, builder.vbrQuality, builder.abrMeanBitrate, builder.lowpassFreq, builder.highpassFreq, builder.id3tagTitle, builder.id3tagArtist, builder.id3tagAlbum, builder.id3tagYear, builder.id3tagComment);
    }

    public int encode(short[] buffer_l, short[] buffer_r, int samples, byte[] mp3buf) {
        return AndroidLame.lameEncode(buffer_l, buffer_r, samples, mp3buf);
    }

    public int encodeBufferInterLeaved(short[] pcm, int samples, byte[] mp3buf) {
        return AndroidLame.encodeBufferInterleaved(pcm, samples, mp3buf);
    }

    public int flush(byte[] mp3buf) {
        return AndroidLame.lameFlush(mp3buf);
    }

    public void close() {
        AndroidLame.lameClose();
    }

    private static native void initializeDefault();

    private static native void initialize(int var0, int var1, int var2, int var3, float var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, String var12, String var13, String var14, String var15, String var16);

    private static native int lameEncode(short[] var0, short[] var1, int var2, byte[] var3);

    private static native int encodeBufferInterleaved(short[] var0, int var1, byte[] var2);

    private static native int lameFlush(byte[] var0);

    private static native void lameClose();

    private static int getIntForMode(LameBuilder.Mode mode) {
        switch (mode) {
            case STEREO: {
                return 0;
            }
            case JSTEREO: {
                return 1;
            }
            case MONO: {
                return 3;
            }
            case DEFAULT: {
                return 4;
            }
        }
        return -1;
    }

    private static int getIntForVbrMode(LameBuilder.VbrMode mode) {
        switch (mode) {
            case VBR_OFF: {
                return 0;
            }
            case VBR_RH: {
                return 2;
            }
            case VBR_ABR: {
                return 3;
            }
            case VBR_MTRH: {
                return 4;
            }
            case VBR_DEFAUT: {
                return 6;
            }
        }
        return -1;
    }

    static {
        System.loadLibrary("androidlame");
    }
}

