/*
 * Decompiled with CFR 0.152.
 */
package com.github.akshay_naik.texthighlighterapi;

import com.github.akshay_naik.texthighlighterapi.C;
import com.github.akshay_naik.texthighlighterapi.Cpp;
import com.github.akshay_naik.texthighlighterapi.Java;
import com.github.akshay_naik.texthighlighterapi.Language;
import com.github.akshay_naik.texthighlighterapi.LibraryConstant;
import java.util.HashMap;
import java.util.StringTokenizer;

public class TextHighlighter
implements LibraryConstant.LanguageConstant,
LibraryConstant.StyleConstant {
    private String defaultColor;
    private String language;
    private HashMap<String, String> colorMap = new HashMap();
    private HashMap<String, String> styleMap = new HashMap();

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getHighlightedText(String stringToBeHighlighted) {
        StringBuilder highlightedText = new StringBuilder();
        String color = "";
        String myToken = "";
        Language selectedLanguage = null;
        StringTokenizer tokenizer = new StringTokenizer(stringToBeHighlighted);
        if ((selectedLanguage = this.selectLanguage(selectedLanguage)) != null) {
            highlightedText = this.getHighlightedTextForLanguage(tokenizer, selectedLanguage);
        } else {
            while (tokenizer.hasMoreTokens()) {
                myToken = tokenizer.nextToken();
                color = this.getColor(myToken);
                highlightedText.append(this.colorTheToken(myToken, color) + " ");
            }
        }
        return new String(highlightedText);
    }

    private Language selectLanguage(Language selectedLanguage) {
        if (this.language != "" && this.language != null) {
            switch (this.language) {
                case "C": {
                    selectedLanguage = new C();
                    break;
                }
                case "C++": {
                    selectedLanguage = new Cpp();
                    break;
                }
                case "JAVA": {
                    selectedLanguage = new Java();
                }
            }
        }
        return selectedLanguage;
    }

    private StringBuilder getHighlightedTextForLanguage(StringTokenizer tokenizer, Language selectedLanguage) {
        StringBuilder highlightedText = new StringBuilder();
        String color = "";
        String myToken = "";
        while (tokenizer.hasMoreTokens()) {
            myToken = tokenizer.nextToken();
            color = selectedLanguage.getColor(myToken);
            highlightedText.append(this.colorTheToken(myToken, color) + " ");
        }
        return highlightedText;
    }

    public void setDefaultColor(String color) {
        this.defaultColor = color == "" || color == null ? "black" : color;
    }

    public String getDefaultColor() {
        if (this.defaultColor == "" || this.defaultColor == null) {
            return this.defaultColor;
        }
        return this.defaultColor;
    }

    private String getColor(String myToken) {
        String color = this.colorMap.get(myToken.toLowerCase());
        if (color == null) {
            color = this.defaultColor;
        }
        return color;
    }

    private String colorTheToken(String token, String color) {
        return "<font color='" + color + "'> " + token + " </font>";
    }

    public void setColorForTheToken(String token, String color) {
        token = token.trim();
        color = color.trim();
        this.colorMap.put(token.toLowerCase(), color);
    }

    public void setColorForTheToken(String[] tokenArray, String color) {
        for (String token : tokenArray) {
            this.setColorForTheToken(token, color);
        }
    }

    public String[] getColorForTheToken(String[] tokenArray) {
        String[] color = new String[tokenArray.length];
        for (int index = 0; index < tokenArray.length; ++index) {
            color[index] = this.getColorForTheToken(tokenArray[index]);
        }
        return color;
    }

    public String getColorForTheToken(String token) {
        token = token.trim();
        String color = "";
        color = this.colorMap.get(token.toLowerCase());
        if (color == null) {
            return this.defaultColor;
        }
        return color;
    }

    public String getStyledText(String stringToBeStyled) {
        StringBuilder styledText = new StringBuilder();
        String style = "";
        String myToken = "";
        StringTokenizer tokenizer = new StringTokenizer(stringToBeStyled);
        while (tokenizer.hasMoreTokens()) {
            myToken = tokenizer.nextToken();
            style = this.getStyle(myToken);
            styledText.append(this.styleTheToken(myToken, style) + " ");
        }
        return new String(styledText);
    }

    public String[] getStyleForTheToken(String[] tokenArray) {
        String[] style = new String[tokenArray.length];
        for (int index = 0; index < tokenArray.length; ++index) {
            style[index] = this.getStyleForTheToken(tokenArray[index]);
        }
        return style;
    }

    private String getStyle(String myToken) {
        String style = this.styleMap.get(myToken.toLowerCase());
        if (style == null) {
            style = "NORMAL";
        }
        return style;
    }

    private String styleTheToken(String token, String style) {
        String taggedText = token;
        switch (style) {
            case "NORMAL": {
                taggedText = token;
                break;
            }
            case "BOLD": {
                taggedText = "<b> " + token + " </b>";
                break;
            }
            case "ITALIC": {
                taggedText = "<i> " + token + " </i>";
                break;
            }
            case "UNDERLINE": {
                taggedText = "<u> " + token + " </u>";
                break;
            }
            case "SUPERSCRIPT": {
                taggedText = "<sup> " + token + " </sup>";
                break;
            }
            case "SUBSCRIPT": {
                taggedText = "<sub> " + token + " </sub>";
                break;
            }
            default: {
                taggedText = token;
            }
        }
        return taggedText;
    }

    public void setStyleForTheToken(String token, String style) {
        token = token.trim();
        style = style.trim();
        this.styleMap.put(token.toLowerCase(), style);
    }

    public void setStyleForTheToken(String[] tokenArray, String style) {
        for (String token : tokenArray) {
            this.setStyleForTheToken(token, style);
        }
    }

    public String getStyleForTheToken(String token) {
        token = token.trim();
        String style = "";
        style = this.styleMap.get(token.toLowerCase());
        if (style == null) {
            return "NORMAL";
        }
        return style;
    }
}

