/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j;

import com.github.myzhan.locust4j.Locust;
import com.github.myzhan.locust4j.runtime.Runner;
import com.github.myzhan.locust4j.runtime.RunnerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTask.class);

    public abstract int getWeight();

    public abstract String getName();

    public abstract void execute() throws Exception;

    @Override
    public void run() {
        Runner runner = Locust.getInstance().getRunner();
        while (!RunnerState.Stopped.equals((Object)runner.getState()) && !RunnerState.Ready.equals((Object)runner.getState())) {
            try {
                if (Locust.getInstance().isRateLimitEnabled()) {
                    boolean blocked = Locust.getInstance().getRateLimiter().acquire();
                    if (blocked) continue;
                    this.execute();
                    continue;
                }
                this.execute();
                continue;
            }
            catch (Exception ex) {
                logger.error("Unknown exception when executing the task", (Throwable)ex);
                Locust.getInstance().recordFailure("unknown", "error", 0L, ex.getMessage());
                continue;
            }
            catch (Error err) {
                logger.error("Unknown exception when executing the task", (Throwable)err);
                throw err;
            }
            break;
        }
        return;
    }
}

