/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import zmq.Ctx;
import zmq.SocketBase;
import zmq.ZMQ;

class ManagedContext {
    private final Lock lock;
    private final Ctx ctx = ZMQ.init(1);
    private final Set<SocketBase> sockets;

    private ManagedContext() {
        this.lock = new ReentrantLock();
        this.sockets = new HashSet<SocketBase>();
    }

    static ManagedContext getInstance() {
        return ContextHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SocketBase createSocket(int type) {
        SocketBase base = this.ctx.createSocket(type);
        this.lock.lock();
        try {
            this.sockets.add(base);
        }
        finally {
            this.lock.unlock();
        }
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy(SocketBase socketBase) {
        try {
            socketBase.setSocketOpt(17, 0);
            socketBase.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lock.lock();
        try {
            this.sockets.remove(socketBase);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        this.lock.lock();
        try {
            for (SocketBase s : this.sockets) {
                try {
                    s.setSocketOpt(17, 0);
                    s.close();
                }
                catch (Exception exception) {}
            }
            this.sockets.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ManagedContext.getInstance().close();
            }
        });
    }

    private static class ContextHolder {
        private static final ManagedContext INSTANCE = new ManagedContext();

        private ContextHolder() {
        }
    }
}

