/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j.ratelimit;

import com.github.myzhan.locust4j.ratelimit.AbstractRateLimiter;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StableRateLimiter
extends AbstractRateLimiter
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(StableRateLimiter.class);
    private final long maxThreshold;
    private final AtomicLong threshold;
    private final long period;
    private final TimeUnit unit;
    private ScheduledExecutorService updateTimer;
    private AtomicBoolean stopped;

    public StableRateLimiter(long maxThreshold) {
        this(maxThreshold, 1L, TimeUnit.SECONDS);
    }

    public StableRateLimiter(long maxThreshold, long period, TimeUnit unit) {
        this.maxThreshold = maxThreshold;
        this.threshold = new AtomicLong(maxThreshold);
        this.period = period;
        this.unit = unit;
        this.stopped = new AtomicBoolean(true);
    }

    @Override
    public void start() {
        this.updateTimer = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("StableRateLimiter-bucket-updater");
                return thread;
            }
        });
        this.updateTimer.scheduleAtFixedRate(this, 0L, this.period, this.unit);
        this.stopped.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StableRateLimiter stableRateLimiter = this;
        synchronized (stableRateLimiter) {
            this.threshold.set(this.maxThreshold);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquire() {
        long permit = this.threshold.decrementAndGet();
        if (permit < 0L) {
            StableRateLimiter stableRateLimiter = this;
            synchronized (stableRateLimiter) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    logger.error("The process of acquiring a permit from rate limiter was interrupted", ex);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        this.updateTimer.shutdownNow();
        this.stopped.set(true);
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }
}

