/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j.ratelimit;

import com.github.myzhan.locust4j.ratelimit.AbstractRateLimiter;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RampUpRateLimiter
extends AbstractRateLimiter {
    private static final Logger logger = LoggerFactory.getLogger(RampUpRateLimiter.class);
    private final long maxThreshold;
    private AtomicLong nextThreshold;
    private final AtomicLong threshold;
    private final long rampUpStep;
    private final long rampUpPeriod;
    private final TimeUnit rampUpTimeUnit;
    private final long refillPeriod;
    private final TimeUnit refillUnit;
    private ScheduledExecutorService bucketUpdater;
    private ScheduledExecutorService thresholdUpdater;
    private final Object lock = new Object();
    private AtomicBoolean stopped;

    public RampUpRateLimiter(long maxThreshold, long rampUpStep, long rampUpPeriod, TimeUnit rampUpTimeUnit, long refillPeriod, TimeUnit refillUnit) {
        this.maxThreshold = maxThreshold;
        this.threshold = new AtomicLong(0L);
        this.nextThreshold = new AtomicLong(0L);
        this.rampUpStep = rampUpStep;
        this.rampUpPeriod = rampUpPeriod;
        this.rampUpTimeUnit = rampUpTimeUnit;
        this.refillPeriod = refillPeriod;
        this.refillUnit = refillUnit;
        this.stopped = new AtomicBoolean(true);
    }

    @Override
    public void start() {
        this.thresholdUpdater = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("StableRateLimiter-threshold-updater");
                return thread;
            }
        });
        this.thresholdUpdater.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long nextValue = RampUpRateLimiter.this.nextThreshold.get() + RampUpRateLimiter.this.rampUpStep;
                if (nextValue < 0L) {
                    nextValue = Long.MAX_VALUE;
                }
                if (nextValue > RampUpRateLimiter.this.maxThreshold) {
                    nextValue = RampUpRateLimiter.this.maxThreshold;
                }
                RampUpRateLimiter.this.nextThreshold.set(nextValue);
            }
        }, 0L, this.rampUpPeriod, this.rampUpTimeUnit);
        this.bucketUpdater = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("StableRateLimiter-bucket-updater");
                return thread;
            }
        });
        this.bucketUpdater.scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = RampUpRateLimiter.this.lock;
                synchronized (object) {
                    RampUpRateLimiter.this.threshold.set(RampUpRateLimiter.this.nextThreshold.get());
                    RampUpRateLimiter.this.lock.notifyAll();
                }
            }
        }, 0L, this.refillPeriod, this.refillUnit);
        this.stopped.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquire() {
        long permit = this.threshold.decrementAndGet();
        if (permit < 0L) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ex) {
                    logger.error("The process of acquiring a permit from rate limiter was interrupted", ex);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        this.bucketUpdater.shutdownNow();
        this.thresholdUpdater.shutdownNow();
        this.stopped.set(true);
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }
}

