/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.net.tcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import zmq.ZError;
import zmq.io.net.Address;

public class TcpUtils {
    private TcpUtils() {
    }

    public static void tuneTcpSocket(SocketChannel channel) throws IOException {
        TcpUtils.setOption(channel, new SocketOptionSetter(){

            @Override
            public boolean setOption(Socket socket) throws SocketException {
                socket.setTcpNoDelay(true);
                return true;
            }
        });
    }

    public static void tuneTcpKeepalives(SocketChannel channel, int tcpKeepAlive, int tcpKeepAliveCnt, int tcpKeepAliveIdle, int tcpKeepAliveIntvl) throws IOException {
        final boolean keepAlive = tcpKeepAlive == 1;
        TcpUtils.setOption(channel, new SocketOptionSetter(){

            @Override
            public boolean setOption(Socket socket) throws SocketException {
                socket.setKeepAlive(keepAlive);
                return true;
            }
        });
    }

    public static boolean setTcpReceiveBuffer(Channel channel, final int rcvbuf) {
        return TcpUtils.setOption(channel, new OptionSetter(){

            @Override
            public boolean setOption(Socket socket) throws SocketException {
                socket.setReceiveBufferSize(rcvbuf);
                return true;
            }

            @Override
            public boolean setOption(ServerSocket socket) throws SocketException {
                socket.setReceiveBufferSize(rcvbuf);
                return true;
            }
        });
    }

    public static boolean setTcpSendBuffer(Channel channel, final int sndbuf) {
        return TcpUtils.setOption(channel, new SocketOptionSetter(){

            @Override
            public boolean setOption(Socket socket) throws SocketException {
                socket.setSendBufferSize(sndbuf);
                return true;
            }
        });
    }

    public static boolean setIpTypeOfService(Channel channel, final int tos) {
        return TcpUtils.setOption(channel, new SocketOptionSetter(){

            @Override
            public boolean setOption(Socket socket) throws SocketException {
                socket.setTrafficClass(tos);
                return true;
            }
        });
    }

    public static boolean setReuseAddress(Channel channel, final boolean reuse) {
        return TcpUtils.setOption(channel, new OptionSetter(){

            @Override
            public boolean setOption(Socket socket) throws SocketException {
                socket.setReuseAddress(reuse);
                return true;
            }

            @Override
            public boolean setOption(ServerSocket socket) throws SocketException {
                socket.setReuseAddress(reuse);
                return true;
            }
        });
    }

    private static boolean setOption(Channel channel, OptionSetter setter) {
        try {
            if (channel instanceof ServerSocketChannel) {
                return setter.setOption(((ServerSocketChannel)channel).socket());
            }
            if (channel instanceof SocketChannel) {
                return setter.setOption(((SocketChannel)channel).socket());
            }
        }
        catch (SocketException e) {
            throw new ZError.IOException(e);
        }
        return false;
    }

    public static void unblockSocket(SelectableChannel ... channels) throws IOException {
        for (SelectableChannel ch : channels) {
            ch.configureBlocking(false);
        }
    }

    public static void enableIpv4Mapping(SelectableChannel channel) {
    }

    public static Address getPeerIpAddress(SocketChannel channel) {
        SocketAddress address = channel.socket().getRemoteSocketAddress();
        return new Address(address);
    }

    private static abstract class SocketOptionSetter
    implements OptionSetter {
        private SocketOptionSetter() {
        }

        @Override
        public boolean setOption(ServerSocket socket) throws SocketException {
            return false;
        }
    }

    private static interface OptionSetter {
        public boolean setOption(Socket var1) throws SocketException;

        public boolean setOption(ServerSocket var1) throws SocketException;
    }
}

