/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j.utils;

import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String md5(String ... inputs) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            for (String input : inputs) {
                messageDigest.update(input.getBytes());
            }
            byte[] bytes = messageDigest.digest();
            StringBuilder sb = new StringBuilder(33);
            for (byte currentByte : bytes) {
                sb.append(Integer.toHexString(currentByte & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error("Cannot get the instance of the MD5 message digest", ex);
            return null;
        }
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            return "unknown";
        }
    }

    public static String getNodeID() {
        String hostname = Utils.getHostname();
        long timeInSecond = Utils.currentTimeInSeconds();
        int randomNumber = new Random().nextInt(1000);
        return String.format("%s_%s", hostname, Utils.md5(String.format("%d%d", timeInSecond, randomNumber)));
    }

    public static long round(long value, int places) {
        double pow = Math.pow(10.0, places);
        double digit = pow * (double)value;
        double div = digit % 1.0;
        double round = div > 0.5 ? Math.ceil(digit) : Math.floor(digit);
        double result = round / pow;
        return (long)result;
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static long currentTimeInSeconds() {
        return Utils.now() / 1000L;
    }
}

