/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j.rpc;

import com.github.myzhan.locust4j.message.Message;
import com.github.myzhan.locust4j.rpc.Client;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.ZMQ;

public class ZeromqClient
implements Client {
    private static final Logger logger = LoggerFactory.getLogger(ZeromqClient.class);
    private ZMQ.Context context = ZMQ.context(1);
    private String identity;
    private ZMQ.Socket dealerSocket;

    public ZeromqClient(String host, int port, String nodeID) {
        this.identity = nodeID;
        this.dealerSocket = this.context.socket(5);
        this.dealerSocket.setIdentity(this.identity.getBytes());
        this.dealerSocket.connect(String.format("tcp://%s:%d", host, port));
        logger.debug("Locust4j is connected to master({}:{})", (Object)host, (Object)port);
    }

    @Override
    public Message recv() throws IOException {
        byte[] bytes = this.dealerSocket.recv();
        return new Message(bytes);
    }

    @Override
    public void send(Message message) throws IOException {
        byte[] bytes = message.getBytes();
        this.dealerSocket.send(bytes);
    }

    @Override
    public void close() {
        this.dealerSocket.close();
        this.context.close();
    }
}

