/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket.pubsub;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import zmq.Msg;
import zmq.pipe.Pipe;
import zmq.socket.pubsub.XPub;
import zmq.util.Utils;

class Mtrie {
    private Set<Pipe> pipes = null;
    private int min = 0;
    private int count = 0;
    private int liveNodes = 0;
    private Mtrie[] next = null;

    final boolean addOnTop(Pipe pipe) {
        return this.addHelper(null, 0, 0, pipe);
    }

    public boolean add(Msg msg, Pipe pipe) {
        return this.addHelper(msg, 1, msg.size() - 1, pipe);
    }

    private boolean addHelper(Msg msg, int start, int size, Pipe pipe) {
        if (size == 0) {
            boolean result;
            boolean bl = result = this.pipes == null;
            if (this.pipes == null) {
                this.pipes = new HashSet<Pipe>();
            }
            this.pipes.add(pipe);
            return result;
        }
        byte c = msg.get(start);
        if (c < this.min || c >= this.min + this.count) {
            if (this.count == 0) {
                this.min = c;
                this.count = 1;
                this.next = null;
            } else if (this.count == 1) {
                int oldc = this.min;
                Mtrie oldp = this.next[0];
                this.count = (this.min < c ? c - this.min : this.min - c) + 1;
                this.next = new Mtrie[this.count];
                this.min = Math.min(this.min, c);
                this.next[oldc - this.min] = oldp;
            } else if (this.min < c) {
                this.count = c - this.min + 1;
                this.next = this.realloc(this.next, this.count, true);
            } else {
                this.count = this.min + this.count - c;
                this.next = this.realloc(this.next, this.count, false);
                this.min = c;
            }
        }
        if (this.count == 1) {
            if (this.next == null) {
                this.next = new Mtrie[1];
                this.next[0] = new Mtrie();
                ++this.liveNodes;
            }
            return this.next[0].addHelper(msg, start + 1, size - 1, pipe);
        }
        if (this.next[c - this.min] == null) {
            this.next[c - this.min] = new Mtrie();
            ++this.liveNodes;
        }
        return this.next[c - this.min].addHelper(msg, start + 1, size - 1, pipe);
    }

    private Mtrie[] realloc(Mtrie[] table, int size, boolean ended) {
        return Utils.realloc(Mtrie.class, table, size, ended);
    }

    public boolean rm(Pipe pipe, IMtrieHandler func, XPub pub) {
        return this.rmHelper(pipe, new byte[0], 0, 0, func, pub);
    }

    private boolean rmHelper(Pipe pipe, byte[] buff, int buffsize, int maxBuffSize, IMtrieHandler func, XPub pub) {
        if (this.pipes != null && this.pipes.remove(pipe) && this.pipes.isEmpty()) {
            func.invoke(null, buff, buffsize, pub);
            this.pipes = null;
        }
        if (buffsize >= maxBuffSize) {
            maxBuffSize = buffsize + 256;
            buff = Utils.realloc(buff, maxBuffSize);
        }
        if (this.count == 0) {
            return true;
        }
        if (this.count == 1) {
            buff[buffsize] = (byte)this.min;
            this.next[0].rmHelper(pipe, buff, ++buffsize, maxBuffSize, func, pub);
            if (this.next[0].isRedundant()) {
                this.next = null;
                this.count = 0;
                --this.liveNodes;
                assert (this.liveNodes == 0);
            }
            return true;
        }
        int newMin = this.min + this.count - 1;
        int newMax = this.min;
        for (int c = 0; c != this.count; ++c) {
            buff[buffsize] = (byte)(this.min + c);
            if (this.next[c] == null) continue;
            this.next[c].rmHelper(pipe, buff, buffsize + 1, maxBuffSize, func, pub);
            if (this.next[c].isRedundant()) {
                this.next[c] = null;
                assert (this.liveNodes > 0);
                --this.liveNodes;
                continue;
            }
            if (c + this.min < newMin) {
                newMin = c + this.min;
            }
            if (c + this.min <= newMax) continue;
            newMax = c + this.min;
        }
        assert (this.count > 1);
        if (this.liveNodes == 0) {
            this.next = null;
            this.count = 0;
        } else if (this.liveNodes == 1) {
            assert (newMin == newMax);
            assert (newMin >= this.min && newMin < this.min + this.count);
            Mtrie node = this.next[newMin - this.min];
            assert (node != null);
            this.next = new Mtrie[]{node};
            this.count = 1;
            this.min = newMin;
        } else if (newMin > this.min || newMax < this.min + this.count - 1) {
            assert (newMax > newMin);
            Mtrie[] oldTable = this.next;
            assert (newMin > this.min || newMax < this.min + this.count - 1);
            assert (newMin >= this.min);
            assert (newMax <= this.min + this.count - 1);
            assert (newMax - newMin + 1 < this.count);
            this.count = newMax - newMin + 1;
            this.next = new Mtrie[this.count];
            System.arraycopy(oldTable, newMin - this.min, this.next, 0, this.count);
            this.min = newMin;
        }
        return true;
    }

    public boolean rm(Msg msg, Pipe pipe) {
        return this.rmHelper(msg, 1, msg.size() - 1, pipe);
    }

    private boolean rmHelper(Msg msg, int start, int size, Pipe pipe) {
        Mtrie nextNode;
        if (size == 0) {
            if (this.pipes != null) {
                boolean erased = this.pipes.remove(pipe);
                assert (erased);
                if (this.pipes.isEmpty()) {
                    this.pipes = null;
                }
            }
            return this.pipes == null;
        }
        byte c = msg.get(start);
        if (this.count == 0 || c < this.min || c >= this.min + this.count) {
            return false;
        }
        Mtrie mtrie = nextNode = this.count == 1 ? this.next[0] : this.next[c - this.min];
        if (nextNode == null) {
            return false;
        }
        boolean ret = nextNode.rmHelper(msg, start + 1, size - 1, pipe);
        if (nextNode.isRedundant()) {
            assert (this.count > 0);
            if (this.count == 1) {
                this.next = null;
                this.count = 0;
                --this.liveNodes;
                assert (this.liveNodes == 0);
            } else {
                this.next[c - this.min] = null;
                assert (this.liveNodes > 1);
                --this.liveNodes;
                if (this.liveNodes == 1) {
                    int i;
                    for (i = 0; i < this.count && this.next[i] == null; ++i) {
                    }
                    assert (i < this.count);
                    this.min += i;
                    this.count = 1;
                    Mtrie old = this.next[i];
                    this.next = new Mtrie[]{old};
                } else if (c == this.min) {
                    int i;
                    for (i = 1; i < this.count && this.next[i] == null; ++i) {
                    }
                    assert (i < this.count);
                    this.min += i;
                    this.count -= i;
                    this.next = this.realloc(this.next, this.count, true);
                } else if (c == this.min + this.count - 1) {
                    int i;
                    for (i = 1; i < this.count && this.next[this.count - 1 - i] == null; ++i) {
                    }
                    assert (i < this.count);
                    this.count -= i;
                    this.next = this.realloc(this.next, this.count, false);
                }
            }
        }
        return ret;
    }

    public void match(ByteBuffer data, int size, IMtrieHandler func, XPub pub) {
        Mtrie current = this;
        int idx = 0;
        while (true) {
            if (current.pipes != null) {
                for (Pipe it : current.pipes) {
                    func.invoke(it, null, 0, pub);
                }
            }
            if (size == 0 || current.count == 0) break;
            byte c = data.get(idx);
            if (current.count == 1) {
                if (c != current.min) break;
                current = current.next[0];
                ++idx;
                --size;
                continue;
            }
            if (c < current.min || c >= current.min + current.count || current.next[c - current.min] == null) break;
            current = current.next[c - current.min];
            ++idx;
            --size;
        }
    }

    private boolean isRedundant() {
        return this.pipes == null && this.liveNodes == 0;
    }

    public static interface IMtrieHandler {
        public void invoke(Pipe var1, byte[] var2, int var3, XPub var4);
    }
}

