/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.net.ipc;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import zmq.io.net.Address;
import zmq.io.net.ProtocolFamily;
import zmq.io.net.StandardProtocolFamily;
import zmq.io.net.tcp.TcpAddress;

public class IpcAddress
implements Address.IZAddress {
    private String name;
    private final InetSocketAddress address;
    private final SocketAddress sourceAddress;

    public IpcAddress(String addr) {
        String[] strings = addr.split(";");
        this.address = this.resolve(strings[0], false, false);
        this.sourceAddress = strings.length == 2 && !"".equals(strings[1]) ? this.resolve(strings[1], false, false) : null;
    }

    @Override
    public String toString() {
        if (this.name == null) {
            return "";
        }
        return "ipc://" + this.name;
    }

    @Override
    public InetSocketAddress resolve(String name, boolean ipv6, boolean local) {
        this.name = name;
        int hash = name.hashCode();
        if (hash < 0) {
            hash = -hash;
        }
        hash %= 55536;
        hash += 10000;
        try {
            return new InetSocketAddress(InetAddress.getByName(null), hash);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public SocketAddress address() {
        return this.address;
    }

    @Override
    public ProtocolFamily family() {
        return StandardProtocolFamily.INET;
    }

    @Override
    public SocketAddress sourceAddress() {
        return this.sourceAddress;
    }

    public static class IpcAddressMask
    extends TcpAddress {
        public IpcAddressMask(String addr, boolean ipv6) {
            super(addr, ipv6);
        }

        public boolean matchAddress(SocketAddress addr) {
            return this.address().equals(addr);
        }
    }
}

