/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j.ratelimit;

import com.github.myzhan.locust4j.Log;
import com.github.myzhan.locust4j.ratelimit.AbstractRateLimiter;
import com.github.myzhan.locust4j.ratelimit.RateUpdater;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class StableRateLimiter
extends AbstractRateLimiter {
    private final long maxThreshold;
    private final AtomicLong threshold;
    private final long period;
    private final TimeUnit unit;
    private ScheduledExecutorService updateTimer;
    private boolean stopped;

    public StableRateLimiter(long maxThreshold) {
        this(maxThreshold, 1L, TimeUnit.SECONDS);
    }

    public StableRateLimiter(long maxThreshold, long period, TimeUnit unit) {
        this.maxThreshold = maxThreshold;
        this.threshold = new AtomicLong(maxThreshold);
        this.period = period;
        this.unit = unit;
        this.stopped = true;
    }

    @Override
    public void start() {
        this.updateTimer = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("update-timer");
                return thread;
            }
        });
        this.updateTimer.scheduleAtFixedRate(new RateUpdater(this, this.period, this.unit), 0L, 1L, TimeUnit.SECONDS);
        this.stopped = false;
        Log.debug(String.format("Task execute rate is limited to %d per %d %s", this.maxThreshold, this.period, this.unit.name().toLowerCase()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquire() {
        long permit = this.threshold.decrementAndGet();
        if (permit < 0L) {
            StableRateLimiter stableRateLimiter = this;
            synchronized (stableRateLimiter) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.stopped = true;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void update() {
        this.threshold.set(this.maxThreshold);
    }

    @Override
    public void stop() {
        this.stopped = true;
        this.updateTimer.shutdownNow();
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }
}

