/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j;

import com.github.myzhan.locust4j.Client;
import com.github.myzhan.locust4j.Locust;
import com.github.myzhan.locust4j.Log;
import com.github.myzhan.locust4j.Message;
import com.github.myzhan.locust4j.Queues;
import com.github.myzhan.locust4j.Receiver;
import com.github.myzhan.locust4j.Sender;
import java.io.IOException;
import org.zeromq.ZMQ;

public class ZeromqClient
implements Client {
    private ZMQ.Context context = ZMQ.context((int)2);
    private ZMQ.Socket pushSocket = this.context.socket(8);
    private ZMQ.Socket pullSocket;

    protected ZeromqClient(String host, int port) {
        this.pushSocket.connect(String.format("tcp://%s:%d", host, port));
        this.pullSocket = this.context.socket(7);
        this.pullSocket.connect(String.format("tcp://%s:%d", host, port + 1));
        Locust.getInstance().submitToCoreThreadPool(new Sender(this));
        Locust.getInstance().submitToCoreThreadPool(new Receiver(this));
        Log.debug(String.format("Locust4j is connected to master(%s:%d|%d)", host, port, port + 1));
    }

    @Override
    public Message recv() throws IOException {
        byte[] bytes = this.pullSocket.recv();
        return new Message(bytes);
    }

    @Override
    public void send(Message message) throws IOException {
        byte[] bytes = message.getBytes();
        this.pushSocket.send(bytes);
        if ("quit".equals(message.getType())) {
            Queues.DISCONNECTED_FROM_MASTER.offer(true);
        }
    }
}

