/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j;

import com.github.myzhan.locust4j.LongIntMap;
import com.github.myzhan.locust4j.Utils;
import java.util.HashMap;
import java.util.Map;

class StatsEntry {
    protected String name = "";
    protected String method = "";
    protected long numRequests;
    protected long numFailures;
    protected long totalResponseTime;
    protected long minResponseTime;
    protected long maxResponseTime;
    protected LongIntMap numReqsPerSec;
    protected LongIntMap responseTimes;
    protected long totalContentLength;
    protected long startTime;
    protected long lastRequestTimestamp;

    protected StatsEntry(String name) {
        this.name = name;
    }

    protected StatsEntry(String name, String method) {
        this.name = name;
        this.method = method;
    }

    protected void reset() {
        this.startTime = Utils.currentTimeInSeconds();
        this.numRequests = 0L;
        this.numFailures = 0L;
        this.totalResponseTime = 0L;
        this.responseTimes = new LongIntMap();
        this.minResponseTime = 0L;
        this.maxResponseTime = 0L;
        this.lastRequestTimestamp = Utils.currentTimeInSeconds();
        this.numReqsPerSec = new LongIntMap();
        this.totalContentLength = 0L;
    }

    protected void log(long responseTime, long contentLength) {
        ++this.numRequests;
        this.logTimeOfRequest();
        this.logResponseTime(responseTime);
        this.totalContentLength += contentLength;
    }

    protected void logTimeOfRequest() {
        long now = Utils.currentTimeInSeconds();
        this.numReqsPerSec.add(now);
        this.lastRequestTimestamp = now;
    }

    protected void logResponseTime(long responseTime) {
        this.totalResponseTime += responseTime;
        if (this.minResponseTime == 0L) {
            this.minResponseTime = responseTime;
        }
        if (responseTime < this.minResponseTime) {
            this.minResponseTime = responseTime;
        }
        if (responseTime > this.maxResponseTime) {
            this.maxResponseTime = responseTime;
        }
        long roundedResponseTime = 0L;
        roundedResponseTime = responseTime < 100L ? responseTime : (responseTime < 1000L ? Utils.round(responseTime, -1) : (responseTime < 10000L ? Utils.round(responseTime, -2) : Utils.round(responseTime, -3)));
        this.responseTimes.add(roundedResponseTime);
    }

    protected void logError(String error) {
        ++this.numFailures;
    }

    protected Map<String, Object> serialize() {
        HashMap<String, Object> result = new HashMap<String, Object>(12);
        result.put("name", this.name);
        result.put("method", this.method);
        result.put("last_request_timestamp", this.lastRequestTimestamp);
        result.put("start_time", this.startTime);
        result.put("num_requests", this.numRequests);
        result.put("num_failures", this.numFailures);
        result.put("total_response_time", this.totalResponseTime);
        result.put("max_response_time", this.maxResponseTime);
        result.put("min_response_time", this.minResponseTime);
        result.put("total_content_length", this.totalContentLength);
        result.put("response_times", this.responseTimes);
        result.put("num_reqs_per_sec", this.numReqsPerSec);
        return result;
    }

    protected Map<String, Object> getStrippedReport() {
        Map<String, Object> report = this.serialize();
        this.reset();
        return report;
    }
}

