/*
 * Decompiled with CFR 0.152.
 */
package zmq.util;

import java.nio.ByteBuffer;

public class Z85 {
    private static final String encoder = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.-:+=^!/*?&<>()[]{}@%$#";
    private static final byte[] decoder = new byte[]{0, 68, 0, 84, 83, 82, 72, 0, 75, 76, 70, 65, 0, 63, 62, 69, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 64, 0, 73, 66, 74, 71, 81, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 77, 0, 78, 67, 0, 0, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 79, 0, 80, 0, 0};

    private Z85() {
    }

    public static String encode(byte[] data, int size) {
        if (size % 4 != 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int byteNbr = 0;
        long value = 0L;
        while (byteNbr < size) {
            int d;
            if ((d = data[byteNbr++] & 0xFF) < 0) {
                System.out.print("");
            }
            value = value * 256L + (long)d;
            if (byteNbr % 4 != 0) continue;
            for (int divisor = 52200625; divisor != 0; divisor /= 85) {
                int index = (int)(value / (long)divisor % 85L);
                if (index < 0) {
                    System.out.print("");
                }
                builder.append(encoder.charAt(index));
            }
            value = 0L;
        }
        assert (builder.length() == size * 5 / 4);
        return builder.toString();
    }

    public static byte[] decode(String string) {
        if (string.length() % 5 != 0) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.allocate(string.length() * 4 / 5);
        int byteNbr = 0;
        int charNbr = 0;
        int stringLen = string.length();
        long value = 0L;
        while (charNbr < stringLen) {
            value = value * 85L + (long)(decoder[string.charAt(charNbr++) - 32] & 0xFF);
            if (charNbr % 5 != 0) continue;
            for (int divisor = 0x1000000; divisor != 0; divisor /= 256) {
                buf.put(byteNbr++, (byte)(value / (long)divisor % 256L));
            }
            value = 0L;
        }
        assert (byteNbr == string.length() * 4 / 5);
        return buf.array();
    }
}

