/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j.message;

import com.github.myzhan.locust4j.message.Visitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;

public class Message {
    private final String type;
    private final Map<String, Object> data;
    private final String nodeID;

    public Message(String type, Map<String, Object> data, String nodeID) {
        this.type = type;
        this.data = data;
        this.nodeID = nodeID;
    }

    public Message(byte[] bytes) throws IOException {
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker(bytes);
        int arrayHeader = unpacker.unpackArrayHeader();
        this.type = unpacker.unpackString();
        if (unpacker.getNextFormat() != MessageFormat.NIL) {
            this.data = new HashMap<String, Object>(6);
            for (int mapSize = unpacker.unpackMapHeader(); mapSize > 0; --mapSize) {
                Object value;
                String key = null;
                if (unpacker.getNextFormat() == MessageFormat.NIL) {
                    unpacker.unpackNil();
                } else {
                    key = unpacker.unpackString();
                }
                MessageFormat messageFormat = unpacker.getNextFormat();
                switch (messageFormat.getValueType()) {
                    case BOOLEAN: {
                        value = unpacker.unpackBoolean();
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(unpacker.unpackFloat());
                        break;
                    }
                    case INTEGER: {
                        value = unpacker.unpackInt();
                        break;
                    }
                    case NIL: {
                        value = null;
                        unpacker.unpackNil();
                        break;
                    }
                    case STRING: {
                        value = unpacker.unpackString();
                        break;
                    }
                    default: {
                        throw new IOException("Message received unsupported type: " + (Object)((Object)messageFormat.getValueType()));
                    }
                }
                if (null == key) continue;
                this.data.put(key, value);
            }
        } else {
            unpacker.unpackNil();
            this.data = null;
        }
        if (unpacker.getNextFormat() != MessageFormat.NIL) {
            this.nodeID = unpacker.unpackString();
        } else {
            unpacker.unpackNil();
            this.nodeID = null;
        }
        unpacker.close();
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public byte[] getBytes() throws IOException {
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        Visitor visitor = new Visitor(packer);
        packer.packArrayHeader(3);
        packer.packString(this.type);
        if (this.data != null) {
            packer.packMapHeader(this.data.size());
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                packer.packString(entry.getKey());
                visitor.visit(entry.getValue());
            }
        } else {
            packer.packNil();
        }
        packer.packString(this.nodeID);
        byte[] bytes = packer.toByteArray();
        packer.close();
        return bytes;
    }

    public String toString() {
        return String.format("%s-%s-%s", this.nodeID, this.type, this.data);
    }
}

