/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j;

import com.github.myzhan.locust4j.Locust;
import com.github.myzhan.locust4j.Log;
import com.github.myzhan.locust4j.Queues;
import com.github.myzhan.locust4j.RequestFailure;
import com.github.myzhan.locust4j.RequestSuccess;
import com.github.myzhan.locust4j.StatsEntry;
import com.github.myzhan.locust4j.StatsError;
import com.github.myzhan.locust4j.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Stats
implements Runnable {
    private Map<String, StatsEntry> entries;
    private Map<String, StatsError> errors;
    private StatsEntry total;
    private long startTime;
    private Object lock = new Object();

    private Stats() {
        this.entries = new HashMap<String, StatsEntry>(8);
        this.errors = new HashMap<String, StatsError>(8);
        this.total = new StatsEntry("Total");
        this.total.reset();
        Locust.getInstance().submitToCoreThreadPool(new StatsTimer(this));
        Locust.getInstance().submitToCoreThreadPool(this);
    }

    protected static Stats getInstance() {
        return StatsInstanceHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeMeUp() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (Exception ex) {
                Log.error(ex.getMessage());
            }
        }
    }

    @Override
    public void run() {
        String name = Thread.currentThread().getName();
        Thread.currentThread().setName(name + "stats");
        while (true) {
            Boolean timeToReport;
            Boolean needToClearStats;
            RequestFailure failureMessage;
            boolean allEmpty = true;
            RequestSuccess successMessage = Queues.REPORT_SUCCESS_TO_STATS.poll();
            if (successMessage != null) {
                this.logRequest(successMessage.requestType, successMessage.name, successMessage.responseTime, successMessage.contentLength);
                allEmpty = false;
            }
            if (null != (failureMessage = Queues.REPORT_FAILURE_TO_STATS.poll())) {
                this.logError(failureMessage.requestType, failureMessage.name, failureMessage.error);
                allEmpty = false;
            }
            if (null != (needToClearStats = Queues.CLEAR_STATS.poll()) && needToClearStats.booleanValue()) {
                this.clearAll();
                allEmpty = false;
            }
            if (null != (timeToReport = Queues.TIME_TO_REPORT.poll())) {
                Map<String, Object> data = this.collectReportData();
                Queues.REPORT_TO_RUNNER.add(data);
                allEmpty = false;
            }
            if (!allEmpty) continue;
            this.sleep();
        }
    }

    private StatsEntry get(String name, String method) {
        StatsEntry entry = this.entries.get(name + method);
        if (null == entry) {
            entry = new StatsEntry(name, method);
            entry.reset();
            this.entries.put(name + method, entry);
        }
        return entry;
    }

    protected void logRequest(String method, String name, long responseTime, long contentLength) {
        this.total.log(responseTime, contentLength);
        this.get(name, method).log(responseTime, contentLength);
    }

    protected void logError(String method, String name, String error) {
        this.total.logError(error);
        this.get(name, method).logError(error);
        String key = method + name + error;
        StatsError entry = this.errors.get(key);
        if (null == entry) {
            entry = new StatsError(name, method, error);
            this.errors.put(key, entry);
        }
        entry.occured();
    }

    protected void clearAll() {
        this.total = new StatsEntry("Total");
        this.total.reset();
        this.entries = new HashMap<String, StatsEntry>(8);
        this.errors = new HashMap<String, StatsError>(8);
        this.startTime = Utils.currentTimeInSeconds();
    }

    protected List serializeStats() {
        ArrayList<Map<String, Object>> entries = new ArrayList<Map<String, Object>>(this.entries.size());
        for (Map.Entry<String, StatsEntry> item : this.entries.entrySet()) {
            StatsEntry entry = item.getValue();
            if (entry.numRequests == 0L && entry.numFailures == 0L) continue;
            entries.add(entry.getStrippedReport());
        }
        return entries;
    }

    protected Map<String, Map<String, Object>> serializeErrors() {
        HashMap<String, Map<String, Object>> errors = new HashMap<String, Map<String, Object>>(8);
        for (Map.Entry<String, StatsError> item : this.errors.entrySet()) {
            String key = item.getKey();
            StatsError error = item.getValue();
            errors.put(key, error.toMap());
        }
        return errors;
    }

    protected Map<String, Object> collectReportData() {
        HashMap<String, Object> data = new HashMap<String, Object>(3);
        data.put("stats", this.serializeStats());
        data.put("stats_total", this.total.getStrippedReport());
        data.put("errors", this.serializeErrors());
        return data;
    }

    private class StatsTimer
    implements Runnable {
        protected static final int SLAVE_REPORT_INTERVAL = 3000;
        protected Stats stats;

        protected StatsTimer(Stats stats2) {
            this.stats = stats2;
        }

        @Override
        public void run() {
            String name = Thread.currentThread().getName();
            Thread.currentThread().setName(name + "stats-timer");
            while (true) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception ex) {
                    Log.error(ex);
                }
                Queues.TIME_TO_REPORT.offer(true);
                Stats.getInstance().wakeMeUp();
            }
        }
    }

    private static class StatsInstanceHolder {
        private static final Stats INSTANCE = new Stats();

        private StatsInstanceHolder() {
        }
    }
}

