/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j;

import com.github.myzhan.locust4j.Visitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class Message {
    private String type;
    private Map<String, Object> data;
    private String nodeID;

    protected Message(byte[] bytes) throws IOException {
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])bytes);
        int arrayHeader = unpacker.unpackArrayHeader();
        this.type = unpacker.unpackString();
        if (unpacker.getNextFormat() != MessageFormat.NIL) {
            this.data = new HashMap<String, Object>(6);
            for (int mapSize = unpacker.unpackMapHeader(); mapSize > 0; --mapSize) {
                Object value;
                String key = null;
                if (unpacker.getNextFormat() == MessageFormat.NIL) {
                    unpacker.unpackNil();
                } else {
                    key = unpacker.unpackString();
                }
                MessageFormat messageFormat = unpacker.getNextFormat();
                switch (messageFormat.getValueType()) {
                    case BOOLEAN: {
                        value = unpacker.unpackBoolean();
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(unpacker.unpackFloat());
                        break;
                    }
                    case INTEGER: {
                        value = unpacker.unpackInt();
                        break;
                    }
                    case NIL: {
                        value = null;
                        unpacker.unpackNil();
                        break;
                    }
                    case STRING: {
                        value = unpacker.unpackString();
                        break;
                    }
                    default: {
                        throw new IOException("Message received unsupported type: " + messageFormat.getValueType());
                    }
                }
                if (null == key) continue;
                this.data.put(key, value);
            }
        } else {
            this.data = null;
        }
        if (unpacker.getNextFormat() != MessageFormat.NIL) {
            this.nodeID = unpacker.unpackString();
        } else {
            unpacker.unpackNil();
            this.nodeID = null;
        }
        unpacker.close();
    }

    protected Message(String type, Map data, String nodeID) {
        this.type = type;
        this.data = data;
        this.nodeID = nodeID;
    }

    protected String getType() {
        return this.type;
    }

    protected Map getData() {
        return this.data;
    }

    protected byte[] getBytes() throws IOException {
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        Visitor visitor = new Visitor((MessagePacker)packer);
        packer.packArrayHeader(3);
        packer.packString(this.type);
        if (this.data != null) {
            packer.packMapHeader(this.data.size());
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                packer.packString(entry.getKey());
                visitor.visit(entry.getValue());
            }
        } else {
            packer.packNil();
        }
        packer.packString(this.nodeID);
        byte[] bytes = packer.toByteArray();
        packer.close();
        return bytes;
    }
}

