/*
 * Decompiled with CFR 0.152.
 */
package com.github.myzhan.locust4j;

import com.github.myzhan.locust4j.LongIntMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.msgpack.core.MessagePacker;

class Visitor {
    final MessagePacker packer;

    Visitor(MessagePacker packer) {
        this.packer = packer;
    }

    void visit(Object value) throws IOException {
        if (null == value) {
            this.visitNull(value);
        } else if (value instanceof String) {
            this.visitString(value);
        } else if (value instanceof Integer) {
            this.visitInt(value);
        } else if (value instanceof Long) {
            this.visitLong(value);
        } else if (value instanceof Boolean) {
            this.visitBool(value);
        } else if (value instanceof Float) {
            this.visitFloat(value);
        } else if (value instanceof Double) {
            this.visitDouble(value);
        } else if (value instanceof Map) {
            this.visitMap(value);
        } else if (value instanceof List) {
            this.visitList(value);
        } else if (value instanceof LongIntMap) {
            this.visitRps(value);
        } else {
            throw new IOException("Cannot pack type unknown type:" + value.getClass().getSimpleName());
        }
    }

    void visitNull(Object value) throws IOException {
        this.packer.packNil();
    }

    void visitString(Object value) throws IOException {
        this.packer.packString((String)value);
    }

    void visitInt(Object value) throws IOException {
        this.packer.packInt((Integer)value);
    }

    void visitLong(Object value) throws IOException {
        this.packer.packInt(((Long)value).intValue());
    }

    void visitBool(Object value) throws IOException {
        this.packer.packBoolean((Boolean)value);
    }

    void visitFloat(Object value) throws IOException {
        this.packer.packFloat(((Float)value).floatValue());
    }

    void visitDouble(Object value) throws IOException {
        this.packer.packFloat(((Double)value).floatValue());
    }

    void visitMap(Object value) throws IOException {
        Map map = (Map)value;
        this.packer.packMapHeader(map.size());
        for (Map.Entry entry : map.entrySet()) {
            this.visitString(entry.getKey());
            this.visit(entry.getValue());
        }
    }

    void visitList(Object value) throws IOException {
        List list = (List)value;
        this.packer.packArrayHeader(list.size());
        for (Object object : list) {
            this.visit(object);
        }
    }

    void visitRps(Object value) throws IOException {
        LongIntMap longIntMap = (LongIntMap)value;
        this.packer.packMapHeader(longIntMap.longIntegerMap.size());
        for (Map.Entry<Long, Integer> entry : longIntMap.longIntegerMap.entrySet()) {
            this.packer.packLong(entry.getKey());
            this.packer.packInt(entry.getValue());
        }
    }
}

