/*
 * Decompiled with CFR 0.152.
 */
package in.myinnos.alphabetsindexfastscrollrecycler;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.recyclerview.widget.RecyclerView;
import in.myinnos.alphabetsindexfastscrollrecycler.IndexFastScrollRecyclerSection;
import in.myinnos.alphabetsindexfastscrollrecycler.R;

public class IndexFastScrollRecyclerView
extends RecyclerView {
    private IndexFastScrollRecyclerSection mScroller = null;
    private GestureDetector mGestureDetector = null;
    private boolean mEnabled = true;
    public int setIndexTextSize = 12;
    public float mIndexbarWidth = 20.0f;
    public float mIndexbarMarginLeft = 5.0f;
    public float mIndexbarMarginRight = 5.0f;
    public float mIndexbarMarginTop = 5.0f;
    public float mIndexbarMarginBottom = 5.0f;
    public int mPreviewPadding = 5;
    public int mIndexBarCornerRadius = 5;
    public float mIndexBarTransparentValue = 0.6f;
    public int mIndexBarStrokeWidth = 2;
    @ColorInt
    public int mSetIndexBarStrokeColor = -16777216;
    @ColorInt
    public int mIndexbarBackgroudColor = -16777216;
    @ColorInt
    public int mIndexbarTextColor = -1;
    @ColorInt
    public int indexbarHighLightTextColor = -16777216;
    public int mPreviewTextSize = 50;
    @ColorInt
    public int mPreviewBackgroudColor = -16777216;
    @ColorInt
    public int mPreviewTextColor = -1;
    public float mPreviewTransparentValue = 0.4f;

    public IndexFastScrollRecyclerView(Context context) {
        super(context);
    }

    public IndexFastScrollRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public IndexFastScrollRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.IndexFastScrollRecyclerView);
            try {
                TypedValue tv;
                this.setIndexTextSize = typedArray.getInt(R.styleable.IndexFastScrollRecyclerView_setIndexTextSize, this.setIndexTextSize);
                this.mIndexbarWidth = typedArray.getFloat(R.styleable.IndexFastScrollRecyclerView_setIndexbarWidth, this.mIndexbarWidth);
                this.mIndexbarMarginLeft = typedArray.getFloat(R.styleable.IndexFastScrollRecyclerView_setIndexbarMargin, this.mIndexbarMarginLeft);
                this.mIndexbarMarginRight = typedArray.getFloat(R.styleable.IndexFastScrollRecyclerView_setIndexbarMargin, this.mIndexbarMarginRight);
                this.mIndexbarMarginTop = typedArray.getFloat(R.styleable.IndexFastScrollRecyclerView_setIndexbarMargin, this.mIndexbarMarginTop);
                this.mIndexbarMarginBottom = typedArray.getFloat(R.styleable.IndexFastScrollRecyclerView_setIndexbarMargin, this.mIndexbarMarginBottom);
                this.mPreviewPadding = typedArray.getInt(R.styleable.IndexFastScrollRecyclerView_setPreviewPadding, this.mPreviewPadding);
                this.mIndexBarCornerRadius = typedArray.getInt(R.styleable.IndexFastScrollRecyclerView_setIndexBarCornerRadius, this.mIndexBarCornerRadius);
                this.mIndexBarTransparentValue = typedArray.getFloat(R.styleable.IndexFastScrollRecyclerView_setIndexBarTransparentValue, this.mIndexBarTransparentValue);
                this.mEnabled = true;
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarShown)) {
                    this.mEnabled = typedArray.getBoolean(R.styleable.IndexFastScrollRecyclerView_setIndexBarShown, this.mEnabled);
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarColor)) {
                    tv = new TypedValue();
                    typedArray.getValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarColor, tv);
                    this.mIndexbarBackgroudColor = tv.type == 3 ? Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setIndexBarColor)) : typedArray.getColor(R.styleable.IndexFastScrollRecyclerView_setIndexBarColor, this.mIndexbarBackgroudColor);
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarTextColor)) {
                    tv = new TypedValue();
                    typedArray.getValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarColor, tv);
                    this.mIndexbarTextColor = tv.type == 3 ? Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setIndexBarTextColor)) : typedArray.getColor(R.styleable.IndexFastScrollRecyclerView_setIndexBarTextColor, this.mIndexbarTextColor);
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarHighlightTextColor)) {
                    tv = new TypedValue();
                    typedArray.getValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarColor, tv);
                    this.indexbarHighLightTextColor = tv.type == 3 ? Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setIndexBarHighlightTextColor)) : typedArray.getColor(R.styleable.IndexFastScrollRecyclerView_setIndexBarHighlightTextColor, this.indexbarHighLightTextColor);
                }
                this.mPreviewTextSize = typedArray.getInt(R.styleable.IndexFastScrollRecyclerView_setPreviewTextSize, this.mPreviewTextSize);
                this.mPreviewTransparentValue = typedArray.getFloat(R.styleable.IndexFastScrollRecyclerView_setPreviewTransparentValue, this.mPreviewTransparentValue);
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setPreviewColor)) {
                    tv = new TypedValue();
                    typedArray.getValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarColor, tv);
                    this.mPreviewBackgroudColor = tv.type == 3 ? Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setPreviewColor)) : typedArray.getColor(R.styleable.IndexFastScrollRecyclerView_setPreviewColor, this.mPreviewBackgroudColor);
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setPreviewTextColor)) {
                    tv = new TypedValue();
                    typedArray.getValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarColor, tv);
                    this.mPreviewTextColor = tv.type == 3 ? Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setPreviewTextColor)) : typedArray.getColor(R.styleable.IndexFastScrollRecyclerView_setPreviewTextColor, this.mPreviewTextColor);
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarStrokeWidth)) {
                    this.mIndexBarStrokeWidth = typedArray.getInt(R.styleable.IndexFastScrollRecyclerView_setIndexBarStrokeWidth, this.mIndexBarStrokeWidth);
                }
                if (typedArray.hasValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarStrokeColor)) {
                    tv = new TypedValue();
                    typedArray.getValue(R.styleable.IndexFastScrollRecyclerView_setIndexBarColor, tv);
                    this.mSetIndexBarStrokeColor = tv.type == 3 ? Color.parseColor((String)typedArray.getString(R.styleable.IndexFastScrollRecyclerView_setIndexBarStrokeColor)) : typedArray.getColor(R.styleable.IndexFastScrollRecyclerView_setIndexBarStrokeColor, this.mSetIndexBarStrokeColor);
                }
            }
            finally {
                typedArray.recycle();
            }
            this.mScroller = new IndexFastScrollRecyclerSection(context, this);
            this.mScroller.setIndexBarVisibility(this.mEnabled);
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mScroller != null) {
            this.mScroller.draw(canvas);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mEnabled) {
            if (this.mScroller != null && this.mScroller.onTouchEvent(ev)) {
                return true;
            }
            if (this.mGestureDetector == null) {
                this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                        return super.onFling(e1, e2, velocityX, velocityY);
                    }
                });
            }
            this.mGestureDetector.onTouchEvent(ev);
        }
        return super.onTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mEnabled && this.mScroller != null && this.mScroller.contains(ev.getX(), ev.getY())) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        super.setAdapter(adapter);
        if (this.mScroller != null) {
            this.mScroller.setAdapter((RecyclerView.Adapter<RecyclerView.ViewHolder>)adapter);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mScroller != null) {
            this.mScroller.onSizeChanged(w, h);
        }
    }

    public void setIndexTextSize(int value) {
        this.mScroller.setIndexTextSize(value);
    }

    public void setIndexbarWidth(float value) {
        this.mScroller.setIndexbarWidth(value);
    }

    public void setIndexbarMargin(float value) {
        this.mScroller.setIndexbarMargin(value);
    }

    public void setIndexbarTopMargin(float value) {
        this.mScroller.setIndexbarTopMargin(value);
    }

    public void setIndexbarBottomMargin(float value) {
        this.mScroller.setIndexbarBottomMargin(value);
    }

    public void setIndexbarHorizontalMargin(float value) {
        this.mScroller.setIndexbarHorizontalMargin(value);
    }

    public void setIndexbarVerticalMargin(float value) {
        this.mScroller.setIndexbarVerticalMargin(value);
    }

    public void setPreviewPadding(int value) {
        this.mScroller.setPreviewPadding(value);
    }

    public void setIndexBarCornerRadius(int value) {
        this.mScroller.setIndexBarCornerRadius(value);
    }

    public void setIndexBarTransparentValue(float value) {
        this.mScroller.setIndexBarTransparentValue(value);
    }

    public void setTypeface(Typeface typeface) {
        this.mScroller.setTypeface(typeface);
    }

    public void setIndexBarVisibility(boolean shown) {
        this.mScroller.setIndexBarVisibility(shown);
        this.mEnabled = shown;
    }

    public void setIndexBarStrokeVisibility(boolean shown) {
        this.mScroller.setIndexBarStrokeVisibility(shown);
    }

    public void setIndexBarStrokeColor(String color) {
        this.mScroller.setIndexBarStrokeColor(Color.parseColor((String)color));
    }

    public void setIndexBarStrokeColor(@ColorRes int color) {
        int colorValue = this.getContext().getResources().getColor(color);
        this.mScroller.setIndexBarStrokeColor(colorValue);
    }

    public void setIndexBarStrokeWidth(int value) {
        this.mScroller.setIndexBarStrokeWidth(value);
    }

    public void setPreviewVisibility(boolean shown) {
        this.mScroller.setPreviewVisibility(shown);
    }

    public void setPreviewTextSize(int value) {
        this.mScroller.setPreviewTextSize(value);
    }

    public void setPreviewColor(@ColorRes int color) {
        int colorValue = this.getContext().getResources().getColor(color);
        this.mScroller.setPreviewColor(colorValue);
    }

    public void setPreviewColor(String color) {
        this.mScroller.setPreviewColor(Color.parseColor((String)color));
    }

    public void setPreviewTextColor(@ColorRes int color) {
        int colorValue = this.getContext().getResources().getColor(color);
        this.mScroller.setPreviewTextColor(colorValue);
    }

    public void setPreviewTransparentValue(float value) {
        this.mScroller.setPreviewTransparentValue(value);
    }

    public void setPreviewTextColor(String color) {
        this.mScroller.setPreviewTextColor(Color.parseColor((String)color));
    }

    public void setIndexBarColor(String color) {
        this.mScroller.setIndexBarColor(Color.parseColor((String)color));
    }

    public void setIndexBarColor(@ColorRes int color) {
        int colorValue = this.getContext().getResources().getColor(color);
        this.mScroller.setIndexBarColor(colorValue);
    }

    public void setIndexBarTextColor(String color) {
        this.mScroller.setIndexBarTextColor(Color.parseColor((String)color));
    }

    public void setIndexBarTextColor(@ColorRes int color) {
        int colorValue = this.getContext().getResources().getColor(color);
        this.mScroller.setIndexBarTextColor(colorValue);
    }

    public void setIndexbarHighLightTextColor(String color) {
        this.mScroller.setIndexbarHighLightTextColor(Color.parseColor((String)color));
    }

    public void setIndexbarHighLightTextColor(@ColorRes int color) {
        int colorValue = this.getContext().getResources().getColor(color);
        this.mScroller.setIndexbarHighLightTextColor(colorValue);
    }

    public void setIndexBarHighLightTextVisibility(boolean shown) {
        this.mScroller.setIndexBarHighLightTextVisibility(shown);
    }

    public void updateSections() {
        this.mScroller.updateSections();
    }
}

