/*
 * Decompiled with CFR 0.152.
 */
package in.myinnos.alphabetsindexfastscrollrecycler;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.Log;
import android.view.MotionEvent;
import android.widget.SectionIndexer;
import androidx.annotation.ColorInt;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import in.myinnos.alphabetsindexfastscrollrecycler.IndexFastScrollRecyclerView;
import java.util.Objects;

public class IndexFastScrollRecyclerSection
extends RecyclerView.AdapterDataObserver {
    private float mIndexbarWidth;
    private float mIndexbarMarginLeft;
    private float mIndexbarMarginRight;
    private float mIndexbarMarginTop;
    private float mIndexbarMarginBottom;
    private final float mPreviewPadding;
    private final float mDensity;
    private final float mScaledDensity;
    private int mListViewWidth;
    private int mListViewHeight;
    private int mCurrentSection = -1;
    private boolean mIsIndexing = false;
    private RecyclerView mRecyclerView;
    private SectionIndexer mIndexer = null;
    private String[] mSections = null;
    private RectF mIndexbarRect;
    private int setIndexTextSize;
    private int setPreviewPadding;
    private boolean previewVisibility = true;
    private int setIndexBarCornerRadius;
    private Typeface setTypeface = null;
    private Boolean setIndexBarVisibility = true;
    private Boolean setSetIndexBarHighLightTextVisibility = false;
    private Boolean setIndexBarStrokeVisibility = true;
    public int mIndexBarStrokeWidth;
    @ColorInt
    private int mIndexBarStrokeColor;
    @ColorInt
    private int indexbarBackgroudColor;
    @ColorInt
    private int indexbarTextColor;
    @ColorInt
    private int indexbarHighLightTextColor;
    private int setPreviewTextSize;
    @ColorInt
    private int previewBackgroundColor;
    @ColorInt
    private int previewTextColor;
    private int previewBackgroudAlpha;
    private int indexbarBackgroudAlpha;
    private Runnable mLastFadeRunnable = null;

    public IndexFastScrollRecyclerSection(Context context, IndexFastScrollRecyclerView recyclerView) {
        this.setIndexTextSize = recyclerView.setIndexTextSize;
        float setIndexbarWidth = recyclerView.mIndexbarWidth;
        float setIndexbarMarginLeft = recyclerView.mIndexbarMarginLeft;
        float setIndexbarMarginRight = recyclerView.mIndexbarMarginRight;
        float setIndexbarMarginTop = recyclerView.mIndexbarMarginTop;
        float setIndexbarMarginBottom = recyclerView.mIndexbarMarginBottom;
        this.setPreviewPadding = recyclerView.mPreviewPadding;
        this.setPreviewTextSize = recyclerView.mPreviewTextSize;
        this.previewBackgroundColor = recyclerView.mPreviewBackgroudColor;
        this.previewTextColor = recyclerView.mPreviewTextColor;
        this.previewBackgroudAlpha = this.convertTransparentValueToBackgroundAlpha(recyclerView.mPreviewTransparentValue);
        this.mIndexBarStrokeColor = recyclerView.mSetIndexBarStrokeColor;
        this.mIndexBarStrokeWidth = recyclerView.mIndexBarStrokeWidth;
        this.setIndexBarCornerRadius = recyclerView.mIndexBarCornerRadius;
        this.indexbarBackgroudColor = recyclerView.mIndexbarBackgroudColor;
        this.indexbarTextColor = recyclerView.mIndexbarTextColor;
        this.indexbarHighLightTextColor = recyclerView.indexbarHighLightTextColor;
        this.indexbarBackgroudAlpha = this.convertTransparentValueToBackgroundAlpha(recyclerView.mIndexBarTransparentValue);
        this.mDensity = context.getResources().getDisplayMetrics().density;
        this.mScaledDensity = context.getResources().getDisplayMetrics().scaledDensity;
        this.mRecyclerView = recyclerView;
        this.setAdapter((RecyclerView.Adapter<RecyclerView.ViewHolder>)this.mRecyclerView.getAdapter());
        this.mIndexbarWidth = setIndexbarWidth * this.mDensity;
        this.mIndexbarMarginLeft = setIndexbarMarginLeft * this.mDensity;
        this.mIndexbarMarginRight = setIndexbarMarginRight * this.mDensity;
        this.mIndexbarMarginTop = setIndexbarMarginTop * this.mDensity;
        this.mIndexbarMarginBottom = setIndexbarMarginBottom * this.mDensity;
        this.mPreviewPadding = (float)this.setPreviewPadding * this.mDensity;
    }

    public void draw(Canvas canvas) {
        if (this.setIndexBarVisibility.booleanValue()) {
            Paint indexbarPaint = new Paint();
            indexbarPaint.setColor(this.indexbarBackgroudColor);
            indexbarPaint.setAlpha(this.indexbarBackgroudAlpha);
            indexbarPaint.setAntiAlias(true);
            canvas.drawRoundRect(this.mIndexbarRect, (float)this.setIndexBarCornerRadius * this.mDensity, (float)this.setIndexBarCornerRadius * this.mDensity, indexbarPaint);
            if (this.setIndexBarStrokeVisibility.booleanValue()) {
                indexbarPaint.setStyle(Paint.Style.STROKE);
                indexbarPaint.setColor(this.mIndexBarStrokeColor);
                indexbarPaint.setStrokeWidth((float)this.mIndexBarStrokeWidth);
                canvas.drawRoundRect(this.mIndexbarRect, (float)this.setIndexBarCornerRadius * this.mDensity, (float)this.setIndexBarCornerRadius * this.mDensity, indexbarPaint);
            }
            if (this.mSections != null && this.mSections.length > 0) {
                if (this.previewVisibility && this.mCurrentSection >= 0 && !Objects.equals(this.mSections[this.mCurrentSection], "")) {
                    Paint previewPaint = new Paint();
                    previewPaint.setColor(this.previewBackgroundColor);
                    previewPaint.setAlpha(this.previewBackgroudAlpha);
                    previewPaint.setAntiAlias(true);
                    previewPaint.setShadowLayer(3.0f, 0.0f, 0.0f, Color.argb((int)64, (int)0, (int)0, (int)0));
                    Paint previewTextPaint = new Paint();
                    previewTextPaint.setColor(this.previewTextColor);
                    previewTextPaint.setAntiAlias(true);
                    previewTextPaint.setTextSize((float)this.setPreviewTextSize * this.mScaledDensity);
                    previewTextPaint.setTypeface(this.setTypeface);
                    float previewTextWidth = previewTextPaint.measureText(this.mSections[this.mCurrentSection]);
                    float previewSize = 2.0f * this.mPreviewPadding + previewTextPaint.descent() - previewTextPaint.ascent();
                    previewSize = Math.max(previewSize, previewTextWidth + 2.0f * this.mPreviewPadding);
                    RectF previewRect = new RectF(((float)this.mListViewWidth - previewSize) / 2.0f, ((float)this.mListViewHeight - previewSize) / 2.0f, ((float)this.mListViewWidth - previewSize) / 2.0f + previewSize, ((float)this.mListViewHeight - previewSize) / 2.0f + previewSize);
                    canvas.drawRoundRect(previewRect, 5.0f * this.mDensity, 5.0f * this.mDensity, previewPaint);
                    canvas.drawText(this.mSections[this.mCurrentSection], previewRect.left + (previewSize - previewTextWidth) / 2.0f - 1.0f, previewRect.top + (previewSize - (previewTextPaint.descent() - previewTextPaint.ascent())) / 2.0f - previewTextPaint.ascent(), previewTextPaint);
                    this.fade(300L);
                }
                Paint indexPaint = new Paint();
                indexPaint.setColor(this.indexbarTextColor);
                indexPaint.setAntiAlias(true);
                indexPaint.setTextSize((float)this.setIndexTextSize * this.mScaledDensity);
                indexPaint.setTypeface(this.setTypeface);
                float sectionHeight = (this.mIndexbarRect.height() - this.mIndexbarMarginTop - this.mIndexbarMarginBottom) / (float)this.mSections.length;
                float paddingTop = (sectionHeight - (indexPaint.descent() - indexPaint.ascent())) / 2.0f;
                for (int i = 0; i < this.mSections.length; ++i) {
                    float paddingLeft;
                    if (this.setSetIndexBarHighLightTextVisibility.booleanValue()) {
                        if (this.mCurrentSection > -1 && i == this.mCurrentSection) {
                            indexPaint.setTypeface(Typeface.create((Typeface)this.setTypeface, (int)1));
                            indexPaint.setTextSize((float)(this.setIndexTextSize + 3) * this.mScaledDensity);
                            indexPaint.setColor(this.indexbarHighLightTextColor);
                        } else {
                            indexPaint.setTypeface(this.setTypeface);
                            indexPaint.setTextSize((float)this.setIndexTextSize * this.mScaledDensity);
                            indexPaint.setColor(this.indexbarTextColor);
                        }
                        paddingLeft = (this.mIndexbarWidth - indexPaint.measureText(this.mSections[i])) / 2.0f;
                        canvas.drawText(this.mSections[i], this.mIndexbarRect.left + paddingLeft, this.mIndexbarRect.top + this.mIndexbarMarginTop + sectionHeight * (float)i + paddingTop - indexPaint.ascent(), indexPaint);
                        continue;
                    }
                    paddingLeft = (this.mIndexbarWidth - indexPaint.measureText(this.mSections[i])) / 2.0f;
                    canvas.drawText(this.mSections[i], this.mIndexbarRect.left + paddingLeft, this.mIndexbarRect.top + this.mIndexbarMarginTop + sectionHeight * (float)i + paddingTop - indexPaint.ascent(), indexPaint);
                }
            }
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                if (!this.contains(ev.getX(), ev.getY())) break;
                this.mIsIndexing = true;
                this.mCurrentSection = this.getSectionByPoint(ev.getY());
                this.scrollToPosition();
                return true;
            }
            case 2: {
                if (!this.mIsIndexing) break;
                if (this.contains(ev.getX(), ev.getY())) {
                    this.mCurrentSection = this.getSectionByPoint(ev.getY());
                    this.scrollToPosition();
                }
                return true;
            }
            case 1: {
                if (!this.mIsIndexing) break;
                this.mIsIndexing = false;
                this.mCurrentSection = -1;
            }
        }
        return false;
    }

    private void scrollToPosition() {
        try {
            int position = this.mIndexer.getPositionForSection(this.mCurrentSection);
            RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
            if (layoutManager instanceof LinearLayoutManager) {
                ((LinearLayoutManager)layoutManager).scrollToPositionWithOffset(position, 0);
            } else if (null != layoutManager) {
                layoutManager.scrollToPosition(position);
            }
        }
        catch (Exception e) {
            Log.d((String)"INDEX_BAR", (String)"Data size returns null");
        }
    }

    public void onSizeChanged(int w, int h) {
        this.mListViewWidth = w;
        this.mListViewHeight = h;
        this.mIndexbarRect = new RectF((float)w - this.mIndexbarMarginLeft - this.mIndexbarWidth, this.mIndexbarMarginTop, (float)w - this.mIndexbarMarginRight, (float)h - this.mIndexbarMarginBottom - (float)(this.mRecyclerView.getClipToPadding() ? 0 : this.mRecyclerView.getPaddingBottom()));
    }

    public void setAdapter(RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
        if (adapter instanceof SectionIndexer) {
            adapter.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)this);
            this.mIndexer = (SectionIndexer)adapter;
            this.mSections = (String[])this.mIndexer.getSections();
        }
    }

    public void onChanged() {
        super.onChanged();
        this.updateSections();
    }

    public void updateSections() {
        this.mSections = (String[])this.mIndexer.getSections();
    }

    public boolean contains(float x, float y) {
        return x >= this.mIndexbarRect.left && y >= this.mIndexbarRect.top && y <= this.mIndexbarRect.top + this.mIndexbarRect.height();
    }

    private int getSectionByPoint(float y) {
        if (this.mSections == null || this.mSections.length == 0) {
            return 0;
        }
        if (y < this.mIndexbarRect.top + this.mIndexbarMarginTop) {
            return 0;
        }
        if (y >= this.mIndexbarRect.top + this.mIndexbarRect.height() - this.mIndexbarMarginTop) {
            return this.mSections.length - 1;
        }
        return (int)((y - this.mIndexbarRect.top - this.mIndexbarMarginTop) / ((this.mIndexbarRect.height() - this.mIndexbarMarginBottom - this.mIndexbarMarginTop) / (float)this.mSections.length));
    }

    private void fade(long delay) {
        if (this.mRecyclerView != null) {
            if (this.mLastFadeRunnable != null) {
                this.mRecyclerView.removeCallbacks(this.mLastFadeRunnable);
            }
            this.mLastFadeRunnable = new Runnable(){

                @Override
                public void run() {
                    IndexFastScrollRecyclerSection.this.mRecyclerView.invalidate();
                }
            };
            this.mRecyclerView.postDelayed(this.mLastFadeRunnable, delay);
        }
    }

    private int convertTransparentValueToBackgroundAlpha(float value) {
        return (int)(255.0f * value);
    }

    public void setIndexTextSize(int value) {
        this.setIndexTextSize = value;
    }

    public void setIndexbarWidth(float value) {
        this.mIndexbarWidth = value;
    }

    public void setIndexbarMargin(float value) {
        this.mIndexbarMarginLeft = value;
        this.mIndexbarMarginRight = value;
        this.mIndexbarMarginTop = value;
        this.mIndexbarMarginBottom = value;
    }

    public void setIndexbarTopMargin(float value) {
        this.mIndexbarMarginTop = value;
    }

    public void setIndexbarBottomMargin(float value) {
        this.mIndexbarMarginBottom = value;
    }

    public void setIndexbarHorizontalMargin(float value) {
        this.mIndexbarMarginLeft = value;
        this.mIndexbarMarginRight = value;
    }

    public void setIndexbarVerticalMargin(float value) {
        this.mIndexbarMarginTop = value;
        this.mIndexbarMarginBottom = value;
    }

    public void setPreviewPadding(int value) {
        this.setPreviewPadding = value;
    }

    public void setIndexBarCornerRadius(int value) {
        this.setIndexBarCornerRadius = value;
    }

    public void setIndexBarTransparentValue(float value) {
        this.indexbarBackgroudAlpha = this.convertTransparentValueToBackgroundAlpha(value);
    }

    public void setTypeface(Typeface typeface) {
        this.setTypeface = typeface;
    }

    public void setIndexBarVisibility(boolean shown) {
        this.setIndexBarVisibility = shown;
    }

    public void setIndexBarStrokeVisibility(boolean shown) {
        this.setIndexBarStrokeVisibility = shown;
    }

    public void setPreviewVisibility(boolean shown) {
        this.previewVisibility = shown;
    }

    public void setIndexBarStrokeWidth(int value) {
        this.mIndexBarStrokeWidth = value;
    }

    public void setPreviewTextSize(int value) {
        this.setPreviewTextSize = value;
    }

    public void setPreviewColor(@ColorInt int color) {
        this.previewBackgroundColor = color;
    }

    public void setPreviewTextColor(@ColorInt int color) {
        this.previewTextColor = color;
    }

    public void setPreviewTransparentValue(float value) {
        this.previewBackgroudAlpha = this.convertTransparentValueToBackgroundAlpha(value);
    }

    public void setIndexBarColor(@ColorInt int color) {
        this.indexbarBackgroudColor = color;
    }

    public void setIndexBarTextColor(@ColorInt int color) {
        this.indexbarTextColor = color;
    }

    public void setIndexBarStrokeColor(@ColorInt int color) {
        this.mIndexBarStrokeColor = color;
    }

    public void setIndexbarHighLightTextColor(@ColorInt int color) {
        this.indexbarHighLightTextColor = color;
    }

    public void setIndexBarHighLightTextVisibility(boolean shown) {
        this.setSetIndexBarHighLightTextVisibility = shown;
    }
}

