/*
 * Decompiled with CFR 0.152.
 */
package in.myinnos.alphabetsindexfastscrollrecycler;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.SectionIndexer;
import in.myinnos.alphabetsindexfastscrollrecycler.IndexFastScrollRecyclerView;

public class IndexFastScrollRecyclerSection
extends RecyclerView.AdapterDataObserver {
    private float mIndexbarWidth;
    private float mIndexbarMargin;
    private float mPreviewPadding;
    private float mDensity;
    private float mScaledDensity;
    private int mListViewWidth;
    private int mListViewHeight;
    private int mCurrentSection = -1;
    private boolean mIsIndexing = false;
    private RecyclerView mRecyclerView = null;
    private SectionIndexer mIndexer = null;
    private String[] mSections = null;
    private RectF mIndexbarRect;
    private int setIndexTextSize = IndexFastScrollRecyclerView.setIndexTextSize;
    private float setIndexbarWidth = IndexFastScrollRecyclerView.mIndexbarWidth;
    private float setIndexbarMargin = IndexFastScrollRecyclerView.mIndexbarMargin;
    private int setPreviewPadding = IndexFastScrollRecyclerView.mPreviewPadding;
    private int setIndexBarCornerRadius = IndexFastScrollRecyclerView.mIndexBarCornerRadius;
    private Typeface setTypeface = null;
    private String indexbarBackgroudColor = IndexFastScrollRecyclerView.mIndexbarBackgroudColor;
    private String indexbarTextColor = IndexFastScrollRecyclerView.mIndexbarTextColor;
    private int indexbarBackgroudAlpha = this.convertTransparentValueToBackgroundAlpha(IndexFastScrollRecyclerView.mIndexBarTransparentValue);
    private int indexPaintPaintColor = -1;
    AttributeSet attrs;
    private static final int WHAT_FADE_PREVIEW = 1;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 1) {
                IndexFastScrollRecyclerSection.this.mRecyclerView.invalidate();
            }
        }
    };

    public IndexFastScrollRecyclerSection(Context context, RecyclerView rv) {
        this.mDensity = context.getResources().getDisplayMetrics().density;
        this.mScaledDensity = context.getResources().getDisplayMetrics().scaledDensity;
        this.mRecyclerView = rv;
        this.setAdapter(this.mRecyclerView.getAdapter());
        this.mIndexbarWidth = this.setIndexbarWidth * this.mDensity;
        this.mIndexbarMargin = this.setIndexbarMargin * this.mDensity;
        this.mPreviewPadding = (float)this.setPreviewPadding * this.mDensity;
    }

    public void draw(Canvas canvas) {
        Paint indexbarPaint = new Paint();
        indexbarPaint.setColor(Color.parseColor((String)this.indexbarBackgroudColor));
        indexbarPaint.setAlpha(this.indexbarBackgroudAlpha);
        indexbarPaint.setAntiAlias(true);
        canvas.drawRoundRect(this.mIndexbarRect, (float)this.setIndexBarCornerRadius * this.mDensity, (float)this.setIndexBarCornerRadius * this.mDensity, indexbarPaint);
        if (this.mSections != null && this.mSections.length > 0) {
            if (this.mCurrentSection >= 0) {
                Paint previewPaint = new Paint();
                previewPaint.setColor(-16777216);
                previewPaint.setAlpha(96);
                previewPaint.setAntiAlias(true);
                previewPaint.setShadowLayer(3.0f, 0.0f, 0.0f, Color.argb((int)64, (int)0, (int)0, (int)0));
                Paint previewTextPaint = new Paint();
                previewTextPaint.setColor(-1);
                previewTextPaint.setAntiAlias(true);
                previewTextPaint.setTextSize(50.0f * this.mScaledDensity);
                previewTextPaint.setTypeface(this.setTypeface);
                float previewTextWidth = previewTextPaint.measureText(this.mSections[this.mCurrentSection]);
                float previewSize = 2.0f * this.mPreviewPadding + previewTextPaint.descent() - previewTextPaint.ascent();
                RectF previewRect = new RectF(((float)this.mListViewWidth - previewSize) / 2.0f, ((float)this.mListViewHeight - previewSize) / 2.0f, ((float)this.mListViewWidth - previewSize) / 2.0f + previewSize, ((float)this.mListViewHeight - previewSize) / 2.0f + previewSize);
                canvas.drawRoundRect(previewRect, 5.0f * this.mDensity, 5.0f * this.mDensity, previewPaint);
                canvas.drawText(this.mSections[this.mCurrentSection], previewRect.left + (previewSize - previewTextWidth) / 2.0f - 1.0f, previewRect.top + this.mPreviewPadding - previewTextPaint.ascent() + 1.0f, previewTextPaint);
                this.fade(300L);
            }
            Paint indexPaint = new Paint();
            indexPaint.setColor(Color.parseColor((String)this.indexbarTextColor));
            indexPaint.setAntiAlias(true);
            indexPaint.setTextSize((float)this.setIndexTextSize * this.mScaledDensity);
            indexPaint.setTypeface(this.setTypeface);
            float sectionHeight = (this.mIndexbarRect.height() - 2.0f * this.mIndexbarMargin) / (float)this.mSections.length;
            float paddingTop = (sectionHeight - (indexPaint.descent() - indexPaint.ascent())) / 2.0f;
            for (int i = 0; i < this.mSections.length; ++i) {
                float paddingLeft = (this.mIndexbarWidth - indexPaint.measureText(this.mSections[i])) / 2.0f;
                canvas.drawText(this.mSections[i], this.mIndexbarRect.left + paddingLeft, this.mIndexbarRect.top + this.mIndexbarMargin + sectionHeight * (float)i + paddingTop - indexPaint.ascent(), indexPaint);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                if (!this.contains(ev.getX(), ev.getY())) break;
                this.mIsIndexing = true;
                this.mCurrentSection = this.getSectionByPoint(ev.getY());
                ((LinearLayoutManager)this.mRecyclerView.getLayoutManager()).scrollToPositionWithOffset(this.mIndexer.getPositionForSection(this.mCurrentSection), 0);
                return true;
            }
            case 2: {
                if (!this.mIsIndexing) break;
                if (this.contains(ev.getX(), ev.getY())) {
                    this.mCurrentSection = this.getSectionByPoint(ev.getY());
                    ((LinearLayoutManager)this.mRecyclerView.getLayoutManager()).scrollToPositionWithOffset(this.mIndexer.getPositionForSection(this.mCurrentSection), 0);
                }
                return true;
            }
            case 1: {
                if (!this.mIsIndexing) break;
                this.mIsIndexing = false;
                this.mCurrentSection = -1;
            }
        }
        return false;
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mListViewWidth = w;
        this.mListViewHeight = h;
        this.mIndexbarRect = new RectF((float)w - this.mIndexbarMargin - this.mIndexbarWidth, this.mIndexbarMargin, (float)w - this.mIndexbarMargin, (float)h - this.mIndexbarMargin);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (adapter instanceof SectionIndexer) {
            adapter.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)this);
            this.mIndexer = (SectionIndexer)adapter;
            this.mSections = (String[])this.mIndexer.getSections();
        }
    }

    public void onChanged() {
        super.onChanged();
        this.mSections = (String[])this.mIndexer.getSections();
    }

    public boolean contains(float x, float y) {
        return x >= this.mIndexbarRect.left && y >= this.mIndexbarRect.top && y <= this.mIndexbarRect.top + this.mIndexbarRect.height();
    }

    private int getSectionByPoint(float y) {
        if (this.mSections == null || this.mSections.length == 0) {
            return 0;
        }
        if (y < this.mIndexbarRect.top + this.mIndexbarMargin) {
            return 0;
        }
        if (y >= this.mIndexbarRect.top + this.mIndexbarRect.height() - this.mIndexbarMargin) {
            return this.mSections.length - 1;
        }
        return (int)((y - this.mIndexbarRect.top - this.mIndexbarMargin) / ((this.mIndexbarRect.height() - 2.0f * this.mIndexbarMargin) / (float)this.mSections.length));
    }

    private void fade(long delay) {
        this.mHandler.removeMessages(0);
        this.mHandler.sendEmptyMessageAtTime(1, SystemClock.uptimeMillis() + delay);
    }

    private int convertTransparentValueToBackgroundAlpha(float value) {
        return (int)(255.0f * value);
    }

    public void setIndexTextSize(int value) {
        this.setIndexTextSize = value;
    }

    public void setIndexbarWidth(float value) {
        this.mIndexbarWidth = value;
    }

    public void setIndexbarMargin(float value) {
        this.mIndexbarMargin = value;
    }

    public void setPreviewPadding(int value) {
        this.setPreviewPadding = value;
    }

    public void setIndexBarCornerRadius(int value) {
        this.setIndexBarCornerRadius = value;
    }

    public void setIndexBarTransparentValue(float value) {
        this.indexbarBackgroudAlpha = this.convertTransparentValueToBackgroundAlpha(value);
    }

    public void setTypeface(Typeface typeface) {
        this.setTypeface = typeface;
    }

    public void setIndexBarColor(String color) {
        this.indexbarBackgroudColor = color;
    }

    public void setIndexBarTextColor(String color) {
        this.indexbarTextColor = color;
    }
}

