/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.util;

import com.github.mygreen.supercsv.annotation.PatternFlag;
import com.github.mygreen.supercsv.builder.BuildCase;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class Utils {
    public static final boolean ENABLED_LIB_JODA_TIME;

    public static boolean isEmpty(String str) {
        if (str == null || str.isEmpty()) {
            return true;
        }
        if (str.length() == 1) {
            return str.charAt(0) == '\u0000';
        }
        return false;
    }

    public static boolean isNotEmpty(String str) {
        return !Utils.isEmpty(str);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !Utils.isEmpty(collection);
    }

    public static boolean isEmpty(Object[] arrays) {
        return arrays == null || arrays.length == 0;
    }

    public static boolean isNotEmpty(Object[] arrays) {
        return !Utils.isEmpty(arrays);
    }

    public static Locale getLocale(String str) {
        if (Utils.isEmpty(str)) {
            return Locale.getDefault();
        }
        if (!str.contains("_")) {
            return new Locale(str);
        }
        String[] split = str.split("_");
        if (split.length == 2) {
            return new Locale(split[0], split[1]);
        }
        return new Locale(split[0], split[1], split[2]);
    }

    public static <T> Optional<T> getAnnotationAttribute(Annotation anno, String attrName, Class<T> attrType) {
        try {
            Method method = anno.annotationType().getMethod(attrName, new Class[0]);
            method.setAccessible(true);
            if (!attrType.equals(method.getReturnType())) {
                return Optional.empty();
            }
            Object value = method.invoke((Object)anno, new Object[0]);
            return Optional.of(value);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> boolean hasAnnotationAttribute(Annotation anno, String attrName, Class<T> attrType) {
        return Utils.getAnnotationAttribute(anno, attrName, attrType).isPresent();
    }

    public static boolean containsBuildCase(Annotation anno, BuildCase buildCase) {
        Objects.requireNonNull(anno);
        Objects.requireNonNull(buildCase);
        Optional<BuildCase[]> attrCases = Utils.getAnnotationAttribute(anno, "cases", BuildCase[].class);
        if (attrCases.isPresent()) {
            BuildCase[] casesValue = attrCases.get();
            if (casesValue.length == 0) {
                return true;
            }
            for (BuildCase value : casesValue) {
                if (value != buildCase) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isEnabledJodaTime() {
        return ENABLED_LIB_JODA_TIME;
    }

    public static Object getPrimitiveDefaultValue(Class<?> type) {
        Objects.requireNonNull(type, "type should not be null.");
        if (!type.isPrimitive()) {
            return null;
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return false;
        }
        if (Character.TYPE.isAssignableFrom(type)) {
            return Character.valueOf('\u0000');
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            return (byte)0;
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            return (short)0;
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return 0;
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return 0L;
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return 0.0;
        }
        return null;
    }

    public static String[] concat(String[] array1, String[] array2) {
        if (array1 == null || array1.length == 0) {
            return Utils.clone(array2);
        }
        if (array2 == null || array2.length == 0) {
            return Utils.clone(array1);
        }
        String[] joinedArray = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static String[] clone(String[] array) {
        if (array == null) {
            return null;
        }
        return (String[])array.clone();
    }

    public static int[] toArray(Collection<Integer> collection) {
        Objects.requireNonNull(collection);
        int size = collection.size();
        int[] array = new int[size];
        int i = 0;
        for (Integer value : collection) {
            array[i] = value;
            ++i;
        }
        return array;
    }

    public static int buildRegexFlags(PatternFlag[] flags) {
        int intFlag = 0;
        for (PatternFlag flag : flags) {
            intFlag |= flag.getValue();
        }
        return intFlag;
    }

    public static String uncapitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuilder(strLen).append(String.valueOf(str.charAt(0)).toLowerCase()).append(str.substring(1)).toString();
    }

    static {
        boolean enabled;
        try {
            Class.forName("org.joda.time.LocalDateTime");
            enabled = true;
        }
        catch (ClassNotFoundException e) {
            enabled = false;
        }
        ENABLED_LIB_JODA_TIME = enabled;
    }
}

