/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.io;

import com.github.mygreen.supercsv.builder.BeanMapping;
import com.github.mygreen.supercsv.builder.BeanMappingFactory;
import com.github.mygreen.supercsv.exception.SuperCsvBindingException;
import com.github.mygreen.supercsv.exception.SuperCsvNoMatchColumnSizeException;
import com.github.mygreen.supercsv.exception.SuperCsvNoMatchHeaderException;
import com.github.mygreen.supercsv.io.AbstractCsvAnnotationBeanReader;
import com.github.mygreen.supercsv.io.BeanMappingCache;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.supercsv.io.ITokenizer;
import org.supercsv.prefs.CsvPreference;

public class CsvAnnotationBeanReader<T>
extends AbstractCsvAnnotationBeanReader<T> {
    public CsvAnnotationBeanReader(Class<T> beanType, Reader reader, CsvPreference preference, Class<?> ... groups) {
        super(reader, preference);
        Objects.requireNonNull(beanType, "beanType should not be null.");
        BeanMappingFactory factory = new BeanMappingFactory();
        this.beanMappingCache = BeanMappingCache.create(factory.create(beanType, groups));
        this.validators.addAll(this.beanMappingCache.getOriginal().getValidators());
    }

    public CsvAnnotationBeanReader(BeanMapping<T> beanMapping, Reader reader, CsvPreference preference) {
        super(reader, preference);
        Objects.requireNonNull(beanMapping, "beanMapping should not be null.");
        this.beanMappingCache = BeanMappingCache.create(beanMapping);
        this.validators.addAll(beanMapping.getValidators());
    }

    public CsvAnnotationBeanReader(Class<T> beanType, ITokenizer tokenizer, CsvPreference preference, Class<?> ... groups) {
        super(tokenizer, preference);
        Objects.requireNonNull(beanType, "beanType should not be null.");
        BeanMappingFactory factory = new BeanMappingFactory();
        this.beanMappingCache = BeanMappingCache.create(factory.create(beanType, groups));
        this.validators.addAll(this.beanMappingCache.getOriginal().getValidators());
    }

    public CsvAnnotationBeanReader(BeanMapping<T> beanMapping, ITokenizer tokenizer, CsvPreference preferences) {
        super(tokenizer, preferences);
        Objects.requireNonNull(beanMapping, "beanMapping should not be null.");
        this.beanMappingCache = BeanMappingCache.create(beanMapping);
        this.validators.addAll(beanMapping.getValidators());
    }

    public String[] getHeader(boolean firstLineCheck) throws IOException {
        String[] header = super.getHeader(firstLineCheck);
        if (this.beanMappingCache.getOriginal().isValidateHeader()) {
            try {
                this.validateHeader(header, this.beanMappingCache.getHeader());
            }
            catch (SuperCsvNoMatchColumnSizeException | SuperCsvNoMatchHeaderException e) {
                this.errorMessages.addAll(this.exceptionConverter.convertAndFormat(e, this.beanMappingCache.getOriginal()));
                throw e;
            }
        }
        return header;
    }

    public List<T> readAll() throws IOException {
        return this.readAll(false);
    }

    public List<T> readAll(boolean continueOnError) throws IOException {
        block7: {
            if (this.beanMappingCache.getOriginal().isHeader()) {
                try {
                    this.getHeader(true);
                }
                catch (SuperCsvNoMatchColumnSizeException | SuperCsvNoMatchHeaderException e) {
                    if (continueOnError) break block7;
                    throw e;
                }
            }
        }
        ArrayList list = new ArrayList();
        while (true) {
            try {
                Object record;
                while ((record = this.read()) != null) {
                    list.add(record);
                }
            }
            catch (SuperCsvBindingException | SuperCsvNoMatchColumnSizeException e) {
                if (continueOnError) continue;
                throw e;
            }
            break;
        }
        return list;
    }
}

