/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.io;

import com.github.mygreen.supercsv.builder.BeanMapping;
import com.github.mygreen.supercsv.builder.CallbackMethod;
import com.github.mygreen.supercsv.exception.SuperCsvBindingException;
import com.github.mygreen.supercsv.exception.SuperCsvNoMatchColumnSizeException;
import com.github.mygreen.supercsv.exception.SuperCsvNoMatchHeaderException;
import com.github.mygreen.supercsv.exception.SuperCsvRowException;
import com.github.mygreen.supercsv.io.BeanMappingCache;
import com.github.mygreen.supercsv.validation.CsvBindingErrors;
import com.github.mygreen.supercsv.validation.CsvError;
import com.github.mygreen.supercsv.validation.CsvExceptionConverter;
import com.github.mygreen.supercsv.validation.CsvValidator;
import com.github.mygreen.supercsv.validation.ValidationContext;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.exception.SuperCsvReflectionException;
import org.supercsv.io.AbstractCsvReader;
import org.supercsv.io.ITokenizer;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.BeanInterfaceProxy;
import org.supercsv.util.CsvContext;
import org.supercsv.util.MethodCache;

public abstract class AbstractCsvAnnotationBeanReader<T>
extends AbstractCsvReader {
    protected BeanMappingCache<T> beanMappingCache;
    protected final List<Object> processedColumns = new ArrayList<Object>();
    protected final MethodCache cache = new MethodCache();
    protected CsvExceptionConverter exceptionConverter = new CsvExceptionConverter();
    protected final List<String> errorMessages = new ArrayList<String>();
    protected final List<CsvValidator<T>> validators = new ArrayList<CsvValidator<T>>();

    public AbstractCsvAnnotationBeanReader(Reader reader, CsvPreference preference) {
        super(reader, preference);
    }

    public AbstractCsvAnnotationBeanReader(ITokenizer tokenizer, CsvPreference preference) {
        super(tokenizer, preference);
    }

    public T read() throws IOException {
        if (this.readRow()) {
            T bean = this.instantiateBean(this.beanMappingCache.getOriginal().getType());
            CsvBindingErrors bindingErrors = new CsvBindingErrors(this.beanMappingCache.getOriginal().getType());
            CsvContext context = new CsvContext(this.getLineNumber(), this.getRowNumber(), 1);
            context.setRowSource(new ArrayList<Object>(this.processedColumns));
            Optional<SuperCsvRowException> rowException = Optional.empty();
            try {
                this.executeCellProcessor(this.processedColumns, this.getColumns(), this.beanMappingCache.getCellProcessorsForReading(), context);
            }
            catch (SuperCsvRowException e) {
                rowException = Optional.of(e);
                List<CsvError> list = this.exceptionConverter.convert((SuperCsvException)e, this.beanMappingCache.getOriginal());
                bindingErrors.addAllErrors(list);
            }
            catch (SuperCsvException e) {
                this.errorMessages.addAll(this.exceptionConverter.convertAndFormat(e, this.beanMappingCache.getOriginal()));
                throw e;
            }
            for (CallbackMethod callbackMethod : this.beanMappingCache.getOriginal().getPreReadMethods()) {
                callbackMethod.invoke(bean, context, bindingErrors, this.beanMappingCache.getOriginal());
            }
            this.populateBean(bean, this.beanMappingCache.getNameMapping(), bindingErrors);
            for (CsvValidator csvValidator : this.validators) {
                csvValidator.validate(bean, bindingErrors, new ValidationContext<T>(context, this.beanMappingCache.getOriginal()));
            }
            for (CallbackMethod callbackMethod : this.beanMappingCache.getOriginal().getPostReadMethods()) {
                callbackMethod.invoke(bean, context, bindingErrors, this.beanMappingCache.getOriginal());
            }
            this.processErrors(bindingErrors, context, rowException);
            return bean;
        }
        return null;
    }

    protected void validateHeader(String[] sourceHeader, String[] definedHeader) {
        if (sourceHeader.length != definedHeader.length) {
            CsvContext context = new CsvContext(1, 1, 1);
            throw new SuperCsvNoMatchColumnSizeException(sourceHeader.length, definedHeader.length, context);
        }
        for (int i = 0; i < sourceHeader.length; ++i) {
            if (sourceHeader[i].equals(definedHeader[i])) continue;
            CsvContext context = new CsvContext(1, 1, i + 1);
            throw new SuperCsvNoMatchHeaderException(sourceHeader, definedHeader, context);
        }
    }

    protected void processErrors(CsvBindingErrors bindingErrors, CsvContext context, Optional<SuperCsvRowException> rowException) {
        if (bindingErrors.hasErrors()) {
            List message = bindingErrors.getAllErrors().stream().map(error -> error.format(this.exceptionConverter.getMessageResolver(), this.exceptionConverter.getMessageInterpolator())).collect(Collectors.toList());
            this.errorMessages.addAll(message);
            SuperCsvBindingException bindingException = new SuperCsvBindingException("has binding error.", context, bindingErrors);
            rowException.ifPresent(re -> bindingException.addAllProcessingErrors(re.getColumnErrors()));
            throw bindingException;
        }
    }

    protected T instantiateBean(Class<T> clazz) {
        Object bean;
        if (clazz.isInterface()) {
            bean = BeanInterfaceProxy.createProxy(clazz);
        } else {
            try {
                bean = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new SuperCsvReflectionException(String.format("error instantiating bean, check that %s has a default no-args constructor", clazz.getName()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new SuperCsvReflectionException("error instantiating bean", (Throwable)e);
            }
        }
        return (T)bean;
    }

    protected void executeCellProcessor(List<Object> destination, List<String> source, CellProcessor[] processors, CsvContext context) {
        if (source.size() != processors.length) {
            throw new SuperCsvNoMatchColumnSizeException(source.size(), processors.length, context);
        }
        destination.clear();
        SuperCsvRowException rowException = new SuperCsvRowException(String.format("row (%d) has errors column", context.getRowNumber()), context);
        for (int i = 0; i < source.size(); ++i) {
            try {
                context.setColumnNumber(i + 1);
                if (processors[i] == null) {
                    destination.add(source.get(i));
                    continue;
                }
                destination.add(processors[i].execute((Object)source.get(i), context));
                continue;
            }
            catch (SuperCsvCellProcessorException e) {
                rowException.addError(e);
                destination.add(source.get(i));
                continue;
            }
            catch (SuperCsvException e) {
                throw e;
            }
        }
        if (rowException.isNotEmptyColumnErrors()) {
            throw rowException;
        }
    }

    protected void populateBean(T resultBean, String[] nameMapping, CsvBindingErrors bindingErrors) {
        for (int i = 0; i < nameMapping.length; ++i) {
            String fieldName = nameMapping[i];
            Object fieldValue = this.processedColumns.get(i);
            if (fieldName == null || fieldValue == null || bindingErrors.hasFieldErrors(fieldName)) continue;
            Method setMethod = this.cache.getSetMethod(resultBean, fieldName, fieldValue.getClass());
            try {
                setMethod.invoke(resultBean, fieldValue);
                continue;
            }
            catch (Exception e) {
                throw new SuperCsvReflectionException(String.format("error invoking method %s()", setMethod.getName()), (Throwable)e);
            }
        }
    }

    public String[] getDefinedHeader() {
        return this.beanMappingCache.getHeader();
    }

    public BeanMapping<T> getBeanMapping() {
        return this.beanMappingCache.getOriginal();
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public CsvExceptionConverter getExceptionConverter() {
        return this.exceptionConverter;
    }

    public void setExceptionConverter(CsvExceptionConverter exceptionConverter) {
        this.exceptionConverter = exceptionConverter;
    }

    public void addValidator(CsvValidator<T> ... validators) {
        this.validators.addAll(Arrays.asList(validators));
    }

    public List<CsvValidator<T>> getValidators() {
        return this.validators;
    }
}

