/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.exception;

import com.github.mygreen.supercsv.validation.CsvBindingErrors;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.supercsv.exception.SuperCsvException;
import org.supercsv.util.CsvContext;

public class SuperCsvBindingException
extends SuperCsvException {
    private static final long serialVersionUID = -7961092348053869573L;
    private final CsvBindingErrors bingingErrors;
    private final List<SuperCsvException> processingErrors = new ArrayList<SuperCsvException>();

    public SuperCsvBindingException(String msg, CsvContext context, CsvBindingErrors bingingErrors) {
        super(msg, context);
        this.bingingErrors = bingingErrors;
    }

    public CsvBindingErrors getBindingErrors() {
        return this.bingingErrors;
    }

    public void addAllProcessingErrors(Collection<SuperCsvException> errors) {
        this.processingErrors.addAll(errors);
    }

    public List<SuperCsvException> getProcessingErrors() {
        return this.processingErrors;
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        int count = 1;
        for (SuperCsvException e : this.processingErrors) {
            s.printf("[ProcessingError-%d] : ", count);
            e.printStackTrace(s);
            ++count;
        }
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        int count = 1;
        for (SuperCsvException e : this.processingErrors) {
            s.printf("[ProcessingError-%d] : ", count);
            e.printStackTrace(s);
            ++count;
        }
    }
}

