/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.format;

import com.github.mygreen.supercsv.cellprocessor.format.AbstractTextFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.TextParseException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SimpleNumberFormatter<T extends Number>
extends AbstractTextFormatter<T> {
    private final Class<T> type;
    private final boolean lenient;
    private final MathContext mathContext;

    public SimpleNumberFormatter(Class<T> type, boolean lenient) {
        this(type, lenient, null);
    }

    public SimpleNumberFormatter(Class<T> type, boolean lenient, MathContext mathContext) {
        Objects.requireNonNull(type);
        this.type = type;
        this.lenient = lenient;
        this.mathContext = mathContext;
    }

    @Override
    public T parse(String text) {
        try {
            BigDecimal number = this.mathContext == null ? new BigDecimal(text) : new BigDecimal(text, this.mathContext);
            return (T)this.parseFromBigDecimal(this.type, number);
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw new TextParseException(text, this.type, e);
        }
    }

    private Number parseFromBigDecimal(Class<? extends Number> type, BigDecimal number) {
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) {
            return this.lenient ? number.byteValue() : number.byteValueExact();
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
            return this.lenient ? number.shortValue() : number.shortValueExact();
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return this.lenient ? number.intValue() : number.intValueExact();
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return this.lenient ? number.longValue() : number.longValueExact();
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return Float.valueOf(number.floatValue());
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return number.doubleValue();
        }
        if (type.isAssignableFrom(BigInteger.class)) {
            return this.lenient ? number.toBigInteger() : number.toBigIntegerExact();
        }
        if (type.isAssignableFrom(BigDecimal.class)) {
            return number;
        }
        throw new IllegalArgumentException(String.format("Not support class type : %s", type.getCanonicalName()));
    }

    @Override
    public String print(T object) {
        if (this.mathContext != null) {
            return this.printNumber(object);
        }
        return object.toString();
    }

    private String printNumber(Object object) {
        if (Byte.class.isAssignableFrom(this.type) || Byte.TYPE.isAssignableFrom(this.type)) {
            return new BigDecimal(((Byte)object).byteValue(), this.mathContext).toPlainString();
        }
        if (Short.class.isAssignableFrom(this.type) || Short.TYPE.isAssignableFrom(this.type)) {
            return new BigDecimal(((Short)object).shortValue(), this.mathContext).toPlainString();
        }
        if (Integer.class.isAssignableFrom(this.type) || Integer.TYPE.isAssignableFrom(this.type)) {
            return new BigDecimal((Integer)object, this.mathContext).toPlainString();
        }
        if (Long.class.isAssignableFrom(this.type) || Long.TYPE.isAssignableFrom(this.type)) {
            return new BigDecimal((Long)object, this.mathContext).toPlainString();
        }
        if (Float.class.isAssignableFrom(this.type) || Float.TYPE.isAssignableFrom(this.type)) {
            return new BigDecimal(((Float)object).floatValue(), this.mathContext).toPlainString();
        }
        if (Double.class.isAssignableFrom(this.type) || Double.TYPE.isAssignableFrom(this.type)) {
            return new BigDecimal((Double)object, this.mathContext).toPlainString();
        }
        if (BigInteger.class.isAssignableFrom(this.type)) {
            return new BigDecimal((BigInteger)object, this.mathContext).toPlainString();
        }
        return object.toString();
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    @Override
    public Map<String, Object> getMessageVariables() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        if (this.mathContext != null) {
            vars.put("precision", this.mathContext.getPrecision());
        }
        return vars;
    }
}

