/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.format;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import com.github.mygreen.supercsv.cellprocessor.format.TextParseException;
import com.github.mygreen.supercsv.cellprocessor.format.TextParser;
import com.github.mygreen.supercsv.util.Utils;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class ParseProcessor<T>
extends ValidationCellProcessor
implements StringCellProcessor {
    private final Class<T> type;
    private final TextParser<T> parser;

    public ParseProcessor(Class<T> type, TextParser<T> parser) {
        ParseProcessor.checkPreconditions(type, parser);
        this.type = type;
        this.parser = parser;
    }

    public ParseProcessor(Class<T> type, TextParser<T> parser, CellProcessor next) {
        super(next);
        ParseProcessor.checkPreconditions(type, parser);
        this.type = type;
        this.parser = parser;
    }

    private static <T> void checkPreconditions(Class<T> type, TextParser<T> parser) {
        if (type == null) {
            throw new NullPointerException("type is null.");
        }
        if (parser == null) {
            throw new NullPointerException("parser is null.");
        }
    }

    public Object execute(Object value, CsvContext context) {
        String text = (String)value;
        if (Utils.isEmpty(text)) {
            if (this.type.isPrimitive()) {
                return this.next.execute(Utils.getPrimitiveDefaultValue(this.type), context);
            }
            if (!String.class.isAssignableFrom(this.type)) {
                return this.next.execute(null, context);
            }
        }
        try {
            T result = this.parser.parse((String)value);
            return this.next.execute(result, context);
        }
        catch (TextParseException e) {
            throw this.createValidationException(context).messageFormat("'%s' could not parse to %s.", value, this.getType().getName()).exception(e).rejectedValue(value).validationMessageIfPresent(this.parser.getValidationMessage()).messageVariables(this.parser.getMessageVariables()).parsedError(true).build();
        }
    }

    public Class<T> getType() {
        return this.type;
    }

    public TextParser<T> getParser() {
        return this.parser;
    }
}

