/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.format;

import com.github.mygreen.supercsv.cellprocessor.format.AbstractTextFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.TextParseException;
import com.github.mygreen.supercsv.cellprocessor.format.TextPrintException;
import com.github.mygreen.supercsv.util.Utils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;

public class JodaFormatWrapper<T>
extends AbstractTextFormatter<T> {
    private final DateTimeFormatter formatter;
    private final Class<T> type;
    private final Method parseMethod;
    private String pattern;

    public JodaFormatWrapper(DateTimeFormatter formatter, Class<T> type) {
        Objects.requireNonNull(formatter);
        Objects.requireNonNull(type);
        this.formatter = formatter;
        this.type = type;
        try {
            this.parseMethod = type.getMethod("parse", String.class, DateTimeFormatter.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException(String.format("Cannot suuport type : %s.", type.getName()));
        }
    }

    @Override
    public T parse(String text) {
        try {
            return (T)this.parseMethod.invoke(this.type, text, this.formatter);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new TextParseException(text, this.type, "Cannot suuport type.");
        }
        catch (IllegalArgumentException e) {
            throw new TextParseException(text, this.type, e);
        }
    }

    @Override
    public String print(T object) {
        if (object instanceof ReadablePartial) {
            return this.formatter.print((ReadablePartial)object);
        }
        if (object instanceof ReadableInstant) {
            return this.formatter.print((ReadableInstant)object);
        }
        throw new TextPrintException(object, String.format("Cannot suuport type [%s].", object.getClass().getName()));
    }

    @Override
    public Optional<String> getPattern() {
        if (Utils.isEmpty(this.pattern)) {
            return Optional.empty();
        }
        return Optional.of(this.pattern);
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public Map<String, Object> getMessageVariables() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        this.getPattern().ifPresent(p -> vars.put("pattern", p));
        return vars;
    }
}

