/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.format;

import com.github.mygreen.supercsv.cellprocessor.format.AbstractTextFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.TextParseException;
import com.github.mygreen.supercsv.util.ArgUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EnumFormatter<T extends Enum<T>>
extends AbstractTextFormatter<T> {
    private final Class<? extends Enum<?>> type;
    private final boolean ignoreCase;
    private final Optional<Method> selectorMethod;
    private final Map<Enum<?>, String> toStringMap;
    private final Map<String, Enum<?>> toObjectMap;

    public EnumFormatter(Class<T> type, boolean ignoreCase) {
        Objects.requireNonNull(type, "type should not be null.");
        this.type = type;
        this.ignoreCase = ignoreCase;
        this.selectorMethod = Optional.empty();
        this.toStringMap = EnumFormatter.createToStringMap(type);
        this.toObjectMap = EnumFormatter.createToObjectMap(type, ignoreCase);
    }

    public EnumFormatter(Class<T> type, boolean ignoreCase, String selector) {
        Objects.requireNonNull(type, "type should not be null.");
        ArgUtils.notEmpty(selector, "selector");
        this.type = type;
        this.ignoreCase = ignoreCase;
        this.selectorMethod = Optional.of(EnumFormatter.getEnumValueMethod(type, selector));
        this.toStringMap = EnumFormatter.createToStringMap(type, selector);
        this.toObjectMap = EnumFormatter.createToObjectMap(type, ignoreCase, selector);
    }

    public EnumFormatter(Class<T> type) {
        this(type, false);
    }

    public EnumFormatter(Class<T> type, String selector) {
        this(type, false, selector);
    }

    private static <T extends Enum<T>> Method getEnumValueMethod(Class<T> enumClass, String selector) {
        try {
            Method method = enumClass.getMethod(selector, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(String.format("not found method '%s'", selector), e);
        }
    }

    private static <T extends Enum<T>> Map<Enum<?>, String> createToStringMap(Class<T> enumClass) {
        EnumSet<Enum> set = EnumSet.allOf(enumClass);
        LinkedHashMap<Enum, String> map = new LinkedHashMap<Enum, String>();
        for (Enum e : set) {
            map.put(e, e.name());
        }
        return Collections.unmodifiableMap(map);
    }

    private static <T extends Enum<T>> Map<Enum<?>, String> createToStringMap(Class<T> enumClass, String selector) {
        Method method = EnumFormatter.getEnumValueMethod(enumClass, selector);
        LinkedHashMap<Enum, String> map = new LinkedHashMap<Enum, String>();
        try {
            EnumSet<Enum> set = EnumSet.allOf(enumClass);
            for (Enum e : set) {
                Object returnValue = method.invoke((Object)e, new Object[0]);
                map.put(e, returnValue.toString());
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("fail get enum value.", e);
        }
        return Collections.unmodifiableMap(map);
    }

    private static <T extends Enum<T>> Map<String, Enum<?>> createToObjectMap(Class<T> enumClass, boolean ignoreCase) {
        EnumSet<Enum> set = EnumSet.allOf(enumClass);
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        for (Enum e : set) {
            String key = ignoreCase ? e.name().toLowerCase() : e.name();
            map.put(key, e);
        }
        return Collections.unmodifiableMap(map);
    }

    private static <T extends Enum<T>> Map<String, Enum<?>> createToObjectMap(Class<T> enumClass, boolean ignoreCase, String selector) {
        Method method = EnumFormatter.getEnumValueMethod(enumClass, selector);
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        try {
            EnumSet<Enum> set = EnumSet.allOf(enumClass);
            for (Enum e : set) {
                Object returnValue = method.invoke((Object)e, new Object[0]);
                String key = ignoreCase ? returnValue.toString().toLowerCase() : returnValue.toString();
                map.put(key, e);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public T parse(String text) {
        String keyText = this.ignoreCase ? text.toLowerCase() : text;
        Optional<Enum<?>> obj = Optional.ofNullable(this.toObjectMap.get(keyText));
        return (T)obj.orElseThrow(() -> new TextParseException(text, this.type));
    }

    @Override
    public String print(T object) {
        Optional<String> text = Optional.ofNullable(this.toStringMap.get(object));
        return text.orElseGet(() -> object.toString());
    }

    public Class<? extends Enum<?>> getType() {
        return this.type;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Optional<Method> getSelectorMethod() {
        return this.selectorMethod;
    }

    public Map<Enum<?>, String> getToStringMap() {
        return this.toStringMap;
    }

    public Map<String, Enum<?>> getToObjectMap() {
        return this.toObjectMap;
    }

    @Override
    public Map<String, Object> getMessageVariables() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("type", this.getType().getName());
        vars.put("ignoreCase", this.isIgnoreCase());
        this.getSelectorMethod().ifPresent(method -> vars.put("selector", method.getName()));
        vars.put("enums", this.getToStringMap().values());
        return vars;
    }
}

