/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.format;

import com.github.mygreen.supercsv.cellprocessor.format.AbstractTextFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.TextParseException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DateFormatWrapper<T extends Date>
extends AbstractTextFormatter<T> {
    private final DateFormat formatter;
    private final Class<T> type;

    public DateFormatWrapper(DateFormat formatter, Class<T> type) {
        Objects.requireNonNull(formatter);
        Objects.requireNonNull(type);
        this.formatter = (DateFormat)formatter.clone();
        this.type = type;
    }

    public DateFormatWrapper(Class<T> type) {
        Objects.requireNonNull(type);
        this.type = type;
        String pattern = Timestamp.class.isAssignableFrom(type) ? "yyyy-MM-dd HH:mm:ss.SSS" : (Time.class.isAssignableFrom(type) ? "HH:mm:ss" : (java.sql.Date.class.isAssignableFrom(type) ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss"));
        this.formatter = new SimpleDateFormat(pattern);
    }

    @Override
    public synchronized String print(Date date) {
        return this.formatter.format(date);
    }

    @Override
    public synchronized T parse(String text) throws TextParseException {
        Date date;
        try {
            date = this.formatter.parse(text);
        }
        catch (ParseException e) {
            throw new TextParseException(text, Date.class);
        }
        if (Timestamp.class.isAssignableFrom(this.type)) {
            return (T)new Timestamp(date.getTime());
        }
        if (Time.class.isAssignableFrom(this.type)) {
            return (T)new Time(date.getTime());
        }
        if (java.sql.Date.class.isAssignableFrom(this.type)) {
            return (T)new java.sql.Date(date.getTime());
        }
        if (Date.class.isAssignableFrom(this.type)) {
            return (T)date;
        }
        throw new TextParseException(text, this.type, "Cannot support type.");
    }

    @Override
    public Optional<String> getPattern() {
        if (this.formatter instanceof SimpleDateFormat) {
            SimpleDateFormat sdf = (SimpleDateFormat)this.formatter;
            return Optional.of(sdf.toPattern());
        }
        return Optional.empty();
    }

    @Override
    public Map<String, Object> getMessageVariables() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        this.getPattern().ifPresent(p -> vars.put("pattern", p));
        return vars;
    }
}

