/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.format;

import com.github.mygreen.supercsv.cellprocessor.format.AbstractTextFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.TextParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BooleanFormatter
extends AbstractTextFormatter<Boolean> {
    private static final String[] DEFAULT_READ_TRUE_VALUES = new String[]{"true", "1", "yes", "on", "y", "t"};
    private static final String[] DEFAULT_READ_FALSE_VALUES = new String[]{"false", "0", "no", "off", "f", "n"};
    private static final String DEFAULT_WRITE_TRUE_VALUE = "true";
    private static final String DEFAULT_WRITE_FALSE_VALUE = "false";
    private final Set<String> readTrueValues;
    private final Set<String> readFalseValues;
    private final String writeTrueValue;
    private final String writeFalseValue;
    private boolean ignoreCase;
    private boolean failToFalse;

    public BooleanFormatter() {
        this(DEFAULT_READ_TRUE_VALUES, DEFAULT_READ_FALSE_VALUES, DEFAULT_WRITE_TRUE_VALUE, DEFAULT_WRITE_FALSE_VALUE, false, false);
    }

    public BooleanFormatter(String[] readTrueValues, String[] readFalseValues, String writeTrueValue, String writeFalseValue, boolean ignoreCase, boolean failToFalse) {
        Objects.requireNonNull(readTrueValues);
        Objects.requireNonNull(readFalseValues);
        this.readTrueValues = BooleanFormatter.toSet(readTrueValues);
        this.readFalseValues = BooleanFormatter.toSet(readFalseValues);
        this.writeTrueValue = writeTrueValue;
        this.writeFalseValue = writeFalseValue;
        this.ignoreCase = ignoreCase;
        this.failToFalse = failToFalse;
    }

    private static Set<String> toSet(String[] values) {
        LinkedHashSet set = new LinkedHashSet();
        Collections.addAll(set, values);
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Boolean parse(String text) {
        if (BooleanFormatter.contains(this.readTrueValues, text, this.ignoreCase)) {
            return Boolean.TRUE;
        }
        if (BooleanFormatter.contains(this.readFalseValues, text, this.ignoreCase)) {
            return Boolean.FALSE;
        }
        if (this.failToFalse) {
            return Boolean.FALSE;
        }
        throw new TextParseException(text, Boolean.class, String.format("'%s' could not be parsed as a Boolean", text));
    }

    private static boolean contains(Set<String> set, String value, boolean ignoreCase) {
        if (ignoreCase) {
            for (String element : set) {
                if (!element.equalsIgnoreCase(value)) continue;
                return true;
            }
            return false;
        }
        return set.contains(value);
    }

    @Override
    public String print(Boolean object) {
        return object != false ? this.writeTrueValue : this.writeFalseValue;
    }

    @Override
    public Map<String, Object> getMessageVariables() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("trueValues", this.readTrueValues);
        vars.put("falseValues", this.readFalseValues);
        vars.put("ignoreCase", this.ignoreCase);
        vars.put("failToFalse", this.failToFalse);
        return vars;
    }
}

