/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class Truncate
extends CellProcessorAdaptor
implements StringCellProcessor {
    private final int maxSize;
    private final String suffix;

    public Truncate(int maxSize, String suffix) {
        Truncate.checkPreconditions(maxSize, suffix);
        this.maxSize = maxSize;
        this.suffix = suffix;
    }

    public Truncate(int maxSize, String suffix, StringCellProcessor next) {
        super((CellProcessor)next);
        Truncate.checkPreconditions(maxSize, suffix);
        this.maxSize = maxSize;
        this.suffix = suffix;
    }

    private static void checkPreconditions(int maxSize, String suffix) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException(String.format("maxSize should be > 0 but was %d", maxSize));
        }
        if (suffix == null) {
            throw new NullPointerException("suffix should not be null");
        }
    }

    public <T> T execute(Object value, CsvContext context) {
        if (value == null) {
            return (T)this.next.execute(value, context);
        }
        String stringValue = value.toString();
        String result = stringValue.length() <= this.maxSize ? stringValue : stringValue.substring(0, this.maxSize) + this.suffix;
        return (T)this.next.execute((Object)result, context);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

