/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class RightPad
extends CellProcessorAdaptor
implements StringCellProcessor {
    private final int padSize;
    private final char padChar;

    public RightPad(int padSize, char padChar) {
        RightPad.checkPreconditions(padSize);
        this.padSize = padSize;
        this.padChar = padChar;
    }

    public RightPad(int padSize, char padChar, StringCellProcessor next) {
        super((CellProcessor)next);
        RightPad.checkPreconditions(padSize);
        this.padSize = padSize;
        this.padChar = padChar;
    }

    private static void checkPreconditions(int padSize) {
        if (padSize <= 0) {
            throw new IllegalArgumentException(String.format("padSize should be > 0 but was %d", padSize));
        }
    }

    public <T> T execute(Object value, CsvContext context) {
        if (value == null) {
            return (T)this.next.execute(value, context);
        }
        String result = this.padding((String)value);
        return (T)this.next.execute((Object)result, context);
    }

    private String padding(String str) {
        int pads = this.padSize - str.length();
        if (pads <= 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length() + pads);
        sb.append(str);
        for (int i = 0; i < pads; ++i) {
            sb.append(this.padChar);
        }
        return sb.toString();
    }

    public int getPadSize() {
        return this.padSize;
    }

    public char getPadChar() {
        return this.padChar;
    }
}

