/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import com.github.mygreen.supercsv.cellprocessor.conversion.PaddingProcessor;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class MultiPad
extends CellProcessorAdaptor
implements StringCellProcessor {
    private final int size;
    private final char padChar;
    private final boolean rightAlign;
    private final boolean chopped;
    private final PaddingProcessor paddingProcessor;

    public MultiPad(int size, char padChar, boolean rightAlign, boolean chopped, PaddingProcessor paddingProcessor) {
        MultiPad.checkPreconditions(size, paddingProcessor);
        this.size = size;
        this.padChar = padChar;
        this.rightAlign = rightAlign;
        this.chopped = chopped;
        this.paddingProcessor = paddingProcessor;
    }

    public MultiPad(int size, char padChar, boolean rightAlign, boolean chopped, PaddingProcessor paddingProcessor, StringCellProcessor next) {
        super((CellProcessor)next);
        MultiPad.checkPreconditions(size, paddingProcessor);
        this.size = size;
        this.padChar = padChar;
        this.rightAlign = rightAlign;
        this.chopped = chopped;
        this.paddingProcessor = paddingProcessor;
    }

    private static void checkPreconditions(int size, PaddingProcessor paddingProcessor) {
        if (size <= 0) {
            throw new IllegalArgumentException(String.format("size should be > 0, but was %d.", size));
        }
        if (paddingProcessor == null) {
            throw new IllegalArgumentException("paddingProcessor should not be null.");
        }
    }

    public <T> T execute(Object value, CsvContext context) {
        String result = this.paddingProcessor.pad(value == null ? "" : (String)value, this.size, this.padChar, this.rightAlign, this.chopped);
        return (T)this.next.execute((Object)result, context);
    }

    public int getSize() {
        return this.size;
    }

    public char getPadChar() {
        return this.padChar;
    }

    public boolean isRightAlign() {
        return this.rightAlign;
    }

    public boolean isChopped() {
        return this.chopped;
    }

    public PaddingProcessor getPaddingProcessor() {
        return this.paddingProcessor;
    }
}

