/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.conversion;

import com.github.mygreen.supercsv.cellprocessor.conversion.AbstractPaddingOperator;
import com.github.mygreen.supercsv.util.ArgUtils;
import java.nio.charset.Charset;

public abstract class ByteSizePaddingProcessor
extends AbstractPaddingOperator {
    private final Charset charset;

    public ByteSizePaddingProcessor(Charset charset) {
        ArgUtils.notNull(charset, "charset");
        this.charset = charset;
    }

    @Override
    public int count(int codePoint) {
        return this.count(String.valueOf(Character.toChars(codePoint)));
    }

    @Override
    public int count(String text) {
        ArgUtils.notNull(text, "text");
        return text.getBytes(this.charset).length;
    }

    public static class EucJp
    extends ByteSizePaddingProcessor {
        public EucJp() {
            super(Charset.forName("EUC-JP"));
        }
    }

    public static class Windows31j
    extends ByteSizePaddingProcessor {
        public Windows31j() {
            super(Charset.forName("Windows-31j"));
        }
    }

    public static class Utf8
    extends ByteSizePaddingProcessor {
        public Utf8() {
            super(Charset.forName("UTF-8"));
        }
    }
}

