/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.annotation.constraint.CsvWordRequire;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConstraintProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.RequiredWordProvider;
import com.github.mygreen.supercsv.cellprocessor.constraint.WordRequire;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class WordRequireFactory
implements ConstraintProcessorFactory<CsvWordRequire> {
    @Override
    public Optional<CellProcessor> create(CsvWordRequire anno, Optional<CellProcessor> next, FieldAccessor field, TextFormatter<?> formatter, Configuration config) {
        ArrayList<String> words = new ArrayList<String>();
        if (anno.value().length > 0) {
            words.addAll(Arrays.asList(anno.value()));
        }
        if (anno.provider().length > 0) {
            RequiredWordProvider provider = (RequiredWordProvider)config.getBeanFactory().create(anno.provider()[0]);
            words.addAll(provider.getRequiredWords(field));
        }
        if (anno.value().length == 0 && anno.provider().length == 0) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.required").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "value or provider").format());
        }
        WordRequire processor = next.map(n -> new WordRequire((Collection<String>)words, (CellProcessor)n)).orElseGet(() -> new WordRequire(words));
        processor.setValidationMessage(anno.message());
        return Optional.of(processor);
    }
}

