/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import com.github.mygreen.supercsv.cellprocessor.format.TextPrinter;
import java.util.HashMap;
import java.util.Map;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.util.CsvContext;

public class UniqueHashCode<T>
extends ValidationCellProcessor {
    private final Map<Integer, ValueObject> encounteredElements = new HashMap<Integer, ValueObject>();
    private final TextPrinter<T> printer;

    public UniqueHashCode(TextPrinter<T> printer) {
        UniqueHashCode.checkPreconditions(printer);
        this.printer = printer;
    }

    public UniqueHashCode(TextPrinter<T> printer, CellProcessor next) {
        super(next);
        UniqueHashCode.checkPreconditions(printer);
        this.printer = printer;
    }

    private static <T> void checkPreconditions(TextPrinter<T> printer) {
        if (printer == null) {
            throw new NullPointerException("printer should not be null.");
        }
    }

    public Object execute(Object value, CsvContext context) {
        if (value == null) {
            return this.next.execute(value, context);
        }
        Object result = value;
        int hashCode = value.hashCode();
        if (this.encounteredElements.containsKey(hashCode)) {
            ValueObject duplicatedObject = this.encounteredElements.get(result);
            throw this.createValidationException(context).messageFormat("duplicate hashCode '%s' encountered.", hashCode).rejectedValue(result).messageVariables("hashCode", hashCode).messageVariables("duplicatedRowNumber", duplicatedObject.rowNumber).messageVariables("duplicatedLineNumber", duplicatedObject.lineNumber).messageVariables("printer", this.getPrinter()).build();
        }
        ValueObject object = new ValueObject(hashCode, context.getRowNumber(), context.getLineNumber());
        this.encounteredElements.put(object.hashCode, object);
        return this.next.execute(value, context);
    }

    public TextPrinter<T> getPrinter() {
        return this.printer;
    }

    private static class ValueObject {
        final int hashCode;
        final int rowNumber;
        final int lineNumber;

        ValueObject(int hashCode, int rowNumber, int lineNumber) {
            this.hashCode = hashCode;
            this.rowNumber = rowNumber;
            this.lineNumber = lineNumber;
        }
    }
}

