/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

public class LengthMin
extends ValidationCellProcessor
implements StringCellProcessor {
    private final int min;

    public LengthMin(int min) {
        LengthMin.checkPreconditions(min);
        this.min = min;
    }

    public LengthMin(int min, CellProcessor next) {
        super(next);
        LengthMin.checkPreconditions(min);
        this.min = min;
    }

    private static void checkPreconditions(int min) {
        if (min < 0) {
            throw new IllegalArgumentException(String.format("min length (%d) should not be < 0", min));
        }
    }

    public Object execute(Object value, CsvContext context) {
        if (value == null) {
            return this.next.execute(value, context);
        }
        String stringValue = value.toString();
        int length = stringValue.length();
        if (length < this.min) {
            throw this.createValidationException(context).messageFormat("the length (%d) of value '%s' does not lie the min (%d) values (inclusive)", length, stringValue, this.min).rejectedValue(stringValue).messageVariables("min", this.getMin()).messageVariables("length", length).build();
        }
        return this.next.execute((Object)stringValue, context);
    }

    public int getMin() {
        return this.min;
    }
}

