/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.annotation.constraint.CsvLengthMax;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.ConstraintProcessorFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.LengthMax;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.exception.SuperCsvInvalidAnnotationException;
import com.github.mygreen.supercsv.localization.MessageBuilder;
import java.util.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class LengthMaxFactory
implements ConstraintProcessorFactory<CsvLengthMax> {
    @Override
    public Optional<CellProcessor> create(CsvLengthMax anno, Optional<CellProcessor> next, FieldAccessor field, TextFormatter<?> formatter, Configuration config) {
        int max = anno.value();
        if (max <= 0) {
            throw new SuperCsvInvalidAnnotationException(anno, MessageBuilder.create("anno.attr.min").var("property", field.getNameWithClass()).varWithAnno("anno", anno.annotationType()).var("attrName", "value").var("attrValue", max).var("min", 1).format());
        }
        LengthMax processor = next.map(n -> new LengthMax(max, (CellProcessor)n)).orElseGet(() -> new LengthMax(max));
        processor.setValidationMessage(anno.message());
        return Optional.of(processor);
    }
}

