/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.cellprocessor.constraint;

import com.github.mygreen.supercsv.cellprocessor.ValidationCellProcessor;
import com.github.mygreen.supercsv.cellprocessor.format.TextPrinter;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public class DateTimeMax<T extends Comparable<T>>
extends ValidationCellProcessor
implements DateCellProcessor {
    private final T max;
    private final boolean inclusive;
    private final TextPrinter<T> printer;

    public DateTimeMax(T max, boolean inclusive, TextPrinter<T> printer) {
        DateTimeMax.checkPreconditions(max, printer);
        this.max = max;
        this.inclusive = inclusive;
        this.printer = printer;
    }

    public DateTimeMax(T max, boolean inclusive, TextPrinter<T> printer, CellProcessor next) {
        super(next);
        DateTimeMax.checkPreconditions(max, printer);
        this.max = max;
        this.inclusive = inclusive;
        this.printer = printer;
    }

    private static <T extends Comparable<T>> void checkPreconditions(T max, TextPrinter<T> printer) {
        if (max == null || printer == null) {
            throw new NullPointerException("max and printer should not be null");
        }
    }

    public Object execute(Object value, CsvContext context) {
        if (value == null) {
            return this.next.execute(value, context);
        }
        Class<?> exepectedClass = this.getMax().getClass();
        if (!exepectedClass.isAssignableFrom(value.getClass())) {
            throw new SuperCsvCellProcessorException(exepectedClass, value, context, (CellProcessor)this);
        }
        Comparable result = (Comparable)value;
        if (!this.validate(result)) {
            throw this.createValidationException(context).messageFormat("%s does not lie the max (%s) value.", this.printValue(result), this.printValue(this.max)).rejectedValue(value).messageVariables("max", this.getMax()).messageVariables("inclusive", this.isInclusive()).messageVariables("printer", this.getPrinter()).build();
        }
        return this.next.execute((Object)result, context);
    }

    private boolean validate(T value) {
        int compared = value.compareTo(this.max);
        if (compared < 0) {
            return true;
        }
        return this.inclusive && compared == 0;
    }

    private String printValue(T value) {
        return this.getPrinter().print(value);
    }

    public T getMax() {
        return this.max;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public TextPrinter<T> getPrinter() {
        return this.printer;
    }
}

