/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder.standard;

import com.github.mygreen.supercsv.builder.AbstractProcessorBuilder;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.TextParseException;

public class CharacterProcessorBuilder
extends AbstractProcessorBuilder<Character> {
    @Override
    protected TextFormatter<Character> getDefaultFormatter(final FieldAccessor field, Configuration config) {
        return new TextFormatter<Character>(){

            @Override
            public Character parse(String text) {
                if (text.length() >= 1) {
                    return Character.valueOf(text.charAt(0));
                }
                throw new TextParseException(text, field.getDeclaredClass(), "Cannot be parsed as a char as it is a String longer than 1 character");
            }

            @Override
            public String print(Character object) {
                return object.toString();
            }

            @Override
            public void setValidationMessage(String validationMessage) {
            }
        };
    }
}

