/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.supercsv.builder.standard;

import com.github.mygreen.supercsv.annotation.constraint.CsvNumberMax;
import com.github.mygreen.supercsv.annotation.constraint.CsvNumberMin;
import com.github.mygreen.supercsv.annotation.constraint.CsvNumberRange;
import com.github.mygreen.supercsv.annotation.format.CsvNumberFormat;
import com.github.mygreen.supercsv.builder.AbstractProcessorBuilder;
import com.github.mygreen.supercsv.builder.Configuration;
import com.github.mygreen.supercsv.builder.FieldAccessor;
import com.github.mygreen.supercsv.cellprocessor.constraint.NumberMaxFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.NumberMinFactory;
import com.github.mygreen.supercsv.cellprocessor.constraint.NumberRangeFactory;
import com.github.mygreen.supercsv.cellprocessor.format.NumberFormatWrapper;
import com.github.mygreen.supercsv.cellprocessor.format.SimpleNumberFormatter;
import com.github.mygreen.supercsv.cellprocessor.format.TextFormatter;
import com.github.mygreen.supercsv.util.Utils;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Currency;
import java.util.Locale;
import java.util.Optional;

public abstract class AbstractNumberProcessorBuilder<N extends Number>
extends AbstractProcessorBuilder<N> {
    @Override
    protected void init() {
        super.init();
        this.registerForConstraint(CsvNumberRange.class, new NumberRangeFactory());
        this.registerForConstraint(CsvNumberMin.class, new NumberMinFactory());
        this.registerForConstraint(CsvNumberMax.class, new NumberMaxFactory());
    }

    @Override
    protected TextFormatter<N> getDefaultFormatter(FieldAccessor field, Configuration config) {
        Optional<NumberFormatWrapper<N>> formatter = this.createFormatter(field, config);
        if (formatter.isPresent()) {
            return formatter.get();
        }
        return this.createSimpleFormatter(field, config);
    }

    protected Optional<NumberFormatWrapper<N>> createFormatter(FieldAccessor field, Configuration config) {
        Optional<CsvNumberFormat> formatAnno = field.getAnnotation(CsvNumberFormat.class);
        if (!formatAnno.isPresent()) {
            return Optional.empty();
        }
        String pattern = formatAnno.get().pattern();
        if (pattern.isEmpty()) {
            return Optional.empty();
        }
        boolean lenient = formatAnno.get().lenient();
        Locale locale = Utils.getLocale(formatAnno.get().locale());
        Optional<Currency> currency = formatAnno.get().currency().isEmpty() ? Optional.empty() : Optional.of(Currency.getInstance(formatAnno.get().currency()));
        RoundingMode roundingMode = formatAnno.get().rounding();
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        DecimalFormat formatter = new DecimalFormat(pattern, symbols);
        formatter.setParseBigDecimal(true);
        formatter.setRoundingMode(roundingMode);
        currency.ifPresent(c -> formatter.setCurrency((Currency)c));
        NumberFormatWrapper wrapper = new NumberFormatWrapper(formatter, field.getType(), lenient);
        wrapper.setValidationMessage(formatAnno.get().message());
        return Optional.of(wrapper);
    }

    protected SimpleNumberFormatter<N> createSimpleFormatter(FieldAccessor field, Configuration config) {
        Optional<CsvNumberFormat> formatAnno = field.getAnnotation(CsvNumberFormat.class);
        if (!formatAnno.isPresent()) {
            return new SimpleNumberFormatter(field.getType(), false);
        }
        boolean lenient = formatAnno.get().lenient();
        RoundingMode roundingMode = formatAnno.get().rounding();
        int precision = formatAnno.get().precision();
        SimpleNumberFormatter formatter = precision >= 0 ? new SimpleNumberFormatter(field.getType(), lenient, new MathContext(precision, roundingMode)) : new SimpleNumberFormatter(field.getType(), lenient);
        formatter.setValidationMessage(formatAnno.get().message());
        return formatter;
    }
}

